% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissot.R
\name{tissot}
\alias{tissot}
\title{Compute Tissot indicatrix properties}
\usage{
tissot(
  x,
  target,
  ...,
  source = "EPSG:4326",
  A = 6378137,
  f.inv = 298.257223563,
  dx = 1e-04
)
}
\arguments{
\item{x}{input coordinates — any xy-ish object: a two-column matrix,
data.frame, tibble, list with \code{x}/\code{y} or \code{lon}/\code{lat} components,
or a length-2 numeric vector for a single point}

\item{target}{target projection CRS string (required)}

\item{...}{ignored}

\item{source}{source CRS (default \code{"EPSG:4326"})}

\item{A}{semi-major axis of the ellipsoid (default WGS84)}

\item{f.inv}{inverse flattening (default WGS84)}

\item{dx}{finite difference step in degrees (default 1e-4)}
}
\value{
A \code{tissot_tbl} tibble with columns: x (lon), y (lat), dx_dlam,
dy_dlam, dx_dphi, dy_dphi, scale_h, scale_k, scale_omega, scale_a,
scale_b, scale_area, angle_deformation, convergence. The \code{source} and
\code{target} CRS strings are stored as attributes.
}
\description{
Compute the Tissot indicatrix at given longitude/latitude locations for a
map projection. Returns scale factors, angular deformation, convergence,
and related distortion properties.
}
\details{
The Jacobian of the projection is computed via finite differences, projecting
all base and offset points in a single batched call to
\code{\link[gdalraster:transform_xy]{gdalraster::transform_xy()}}. All subsequent calculations (SVD, distortion
metrics) are fully vectorized.

Input 'x' is assumed to be longitude,latitude values, with default 'EPSG:4326'. Set 'source'
for a different 'geographic' coordinate reference system.
}
\examples{
tissot(c(0, 45), "+proj=robin")
tissot(cbind(seq(-180, 180, by = 30), 0), "+proj=robin")
}
\seealso{
\code{\link[=indicatrix]{indicatrix()}}, \code{\link[=tissot_map]{tissot_map()}}, \code{\link[=tissot_unproject]{tissot_unproject()}}, \code{\link[gdalraster:transform_xy]{gdalraster::transform_xy()}}
}
