% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour.R, R/fill.R
\name{scale_colour_tintin_d}
\alias{scale_colour_tintin_d}
\alias{scale_colour_tintin_c}
\alias{scale_fill_tintin_d}
\alias{scale_fill_tintin_c}
\title{Tintin Colour Scales}
\usage{
scale_colour_tintin_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus",
  aesthetics = "colour"
)

scale_colour_tintin_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus",
  values = NULL,
  na.value = "grey50",
  guide = "colourbar",
  aesthetics = "colour"
)

scale_fill_tintin_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus",
  aesthetics = "fill"
)

scale_fill_tintin_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "the_blue_lotus",
  values = NULL,
  na.value = "grey50",
  guide = "colourbar",
  aesthetics = "fill"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}, or \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}} to control name, limits, breaks,
labels and so forth.}

\item{alpha}{The alpha transparency, a number in \verb{[0,1]}, see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in \verb{[0,1]} at which the color map begins.}

\item{end}{The (corrected) hue in \verb{[0,1]} at which the color map ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Options are available:
\itemize{
\item "Tintin in the Land of the Soviets"
\item "Tintin in the Congo"
\item "Tintin in America"
\item "Cigars of the Pharaoh"
\item "The Blue Lotus" (Standard)
\item "The Broken Ear"
\item "The Black Island"
\item "King Ottokar's Sceptre"
\item "The Crab with the Golden Claws"
\item "The Shooting Star"
\item "The Secret of the Unicorn"
\item "Red Rackham's Treasure"
\item "The Seven Crystal Balls"
\item "Prisoners of the Sun"
\item "Land of Black Gold"
\item "Destination Moon"
\item "Explorers on the Moon"
\item "The Calculus Affair"
\item "The Red Sea Sharks"
\item "Tintin in Tibet"
\item "The Castafiore Emerald"
\item "Flight 714 to Sydney"
\item "Tintin and the Picaros"
\item "Tintin and Alph-Art"
}}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}

\item{values}{if colours should not be evenly positioned along the gradient this
vector gives the position (between 0 and 1) for each colour in the colours vector.}

\item{na.value}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
A \code{ggproto} object for use with \code{ggplot2}.
}
\description{
The \code{tintin} scales provide colour maps for the different Tintin
covers.
}
\examples{
library(dplyr)
library(ggplot2)
library(tintin)

total_head_trauma <- tintin_head_trauma \%>\%
  arrange(-loss_of_consciousness_length) \%>\%
  filter(row_number() <= 5)

# discrete scale

ggplot(total_head_trauma) +
  geom_col(aes(x = cause_of_injury, y = loss_of_consciousness_length,
    fill = book_title), position = "dodge") +
  labs(x = "Cause of injury", y = "Loss of consciousness length",
    title = "Top five causes of injury") +
  theme_minimal() +
  scale_fill_tintin_d(option = "cigars_of_the_pharaoh", direction = -1) +
  coord_flip()

# continuous scale

# continuous scale
ggplot(total_head_trauma) +
 geom_col(aes(
   x = cause_of_injury, y = loss_of_consciousness_length,
   fill = year
 ), position = "dodge") +
 labs(
   x = "Cause of injury", y = "Loss of consciousness length",
   title = "Top five causes of injury"
 ) +
 theme_minimal() +
 scale_fill_tintin_c(option = "cigars_of_the_pharaoh", direction = -1)

}
\concept{colour scales}
