% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{date_time}
\alias{date_time}
\alias{date_time_split}
\title{Construct Date-Time Indices from Date and Time Components}
\usage{
date_time(d, H, M, S, tz = NULL, grid = FALSE)

date_time_split(x)
}
\arguments{
\item{d}{an object of \code{tind} class of type date (type \code{"d"})
or an R object coercible to it.}

\item{H}{a numeric vector with hour values or an R object coercible to
time index of time-of-day type (type \code{"h"}).}

\item{M}{(optional) a numeric vector with minutes.}

\item{S}{(optional) a numeric vector with seconds.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}

\item{grid}{a logical value, if \code{TRUE} date-time indices are constructed
from all combinations of dates and times (\code{FALSE} by default).}

\item{x}{an object of \code{tind} class of type date-time (type \code{"t"})
or an R object coercible to it.}
}
\value{
\code{date_time} returns an object of \code{tind} class
with date-time indices (type \code{"t"}). \code{date_time_split}
returns a two-element list with vectors of dates (\code{$date}) and times (\code{$time}).
}
\description{
\code{date_time} can be used to create date-time indices from its components:
date and time of day (hour, minute, and second).

\code{date_time_split} performs the opposite computation: given date-time
indices, it returns a two-element list with vectors of dates and times.
}
\details{
If arguments of \code{date_time} are of different length, they are recycled.

When \code{grid} is set to \code{TRUE}, date-time indices are constructed
from all combinations of dates and times in a way similar to how
functions \code{expand.grid} and \code{kronecker} work, see Examples.

If \code{H} argument is numeric, time of day is constructed from \code{H},
\code{M}, and \code{S} arguments. In the last step date and time are combined
in order to construct date-time index. If \code{H} is not numeric,
\code{M} and \code{S} should not be supplied and time of day is constructed
from \code{H} argument only.

When provided without \code{H} argument \code{date_time} behaves just like
\code{as.date_time} i.e. returns the beginning of a day.

When an hour occurs twice in a day (due to DST/UTC offset changes),
the second occurrence is selected with a warning. When hour is missing
(for the same reason), \code{NA} is returned with a warning. See Examples.
}
\examples{
date_time(today() + (0:1), "11:25:20.75")
date_time(today() + (0:1), as.time("11:25:20.75"))
date_time(today() + (0:1), 11, 25, 20.75)
date_time(today() + (0:1), "11:25:20")
date_time(today() + (0:1), 11, 25, 20)
date_time(today() + (0:1), "11:25")
date_time(today() + (0:1), 11, 25)
date_time(today() + (0:1), "11")
date_time(today() + (0:1), 11)
date_time(today() + (0:1))
# using 'grid' argument
date_time(today() + 0:2, c(8, 12, 16))
date_time(today() + 0:2, c(8, 12, 16), grid = TRUE)

# split date-time
(nw <- now())
date_time_split(nw)

# corner cases (with warnings)
if ("Europe/Warsaw" \%in\% OlsonNames()) try({
    # 2020-10-25 had 25h with 02:00 repeated
    date_time("2020-10-25", 0:2, tz = "Europe/Warsaw")
})
if ("Europe/Warsaw" \%in\% OlsonNames()) try({
    # 2021-03-28 had 23h with 02:00 missing
    date_time("2021-03-28", 0:2, tz = "Europe/Warsaw")
})

}
\seealso{
\code{\link{tind}} constructor, \link{time-index-components},
\code{\link{tzone}}.
}
