% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_p_wide.R
\name{tw_get_p_wide}
\alias{tw_get_p_wide}
\title{Efficiently get a wide table with various properties of a given set of
Wikidata identifiers}
\usage{
tw_get_p_wide(
  id,
  p,
  label = FALSE,
  property_label_as_column_name = FALSE,
  both_id_and_label = FALSE,
  only_first = FALSE,
  preferred = FALSE,
  unlist = FALSE,
  collapse = ";",
  language = tidywikidatar::tw_get_language(),
  id_df = NULL,
  id_df_label = NULL,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{p}{A character vector, a property. Must always start with the capital
letter "P", e.g. "P31" for "instance of".}

\item{label}{Logical, defaults to \code{FALSE}. If \code{TRUE} labels of Wikidata Q
identifiers are reported instead of the identifiers themselves (or labels
are presented along of them, if \code{both_id_and_label} is set to \code{TRUE})}

\item{property_label_as_column_name}{Logical, defaults to \code{FALSE}. If \code{FALSE},
names of columns with properties are the "P" identifiers of the property.
If \code{TRUE}, the label of the correspondent property is assigned as column
name.}

\item{both_id_and_label}{Logical, defaults to \code{FALSE}. Relevant only if \code{label}
is set to \code{TRUE}, otherwise ignored. If \code{TRUE}, the label is added as a
separate column along the original one. Column name is the same as the
property column, followed by "_label".}

\item{only_first}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it just keeps the
first relevant property value for each id (or \code{NA} if none is available),
and returns a character vector. Warning: this likely discards valid values,
so make sure this is really what you want. If \code{FALSE}, returns a list of
the same length as input, with all values for each id stored in a list if
more than one is found.}

\item{preferred}{Logical, defaults to \code{FALSE}. If \code{TRUE}, returns properties
that have rank "preferred" if available; if no "preferred" property is
found, then it is ignored.}

\item{unlist}{Logical, defaults to \code{FALSE}. Typically used sharing or exporting
data as csv files. Collapses all properties in a single string. The
separator is defined by the \code{collapse} parameter. Relevant only when
\code{only_first} is set to \code{FALSE}.}

\item{collapse}{Defaults to ";". Character used to separate results when
\code{unlist} is set to \code{TRUE}.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{id_df}{Default to \code{NULL}. If given, it should be a dataframe typically
generated with \code{\link[=tw_get]{tw_get()}}, and is used instead of calling Wikidata or
using SQLite cache. Ignored when \code{id} is of length more than one.}

\item{id_df_label}{Defaults to NULL. If given, it should be a dataframe
typically generated with \code{\link[=tw_get]{tw_get()}} with \emph{all} items for which labels will
be requested. It is used instead of calling Wikidata or relying on cache.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}
}
\value{
A data frame, with a column for each given property.
}
\description{
Efficiently get a wide table with various properties of a given set of
Wikidata identifiers
}
\examples{

if (interactive()) {
  tw_get_p_wide(
    id = c("Q180099", "Q228822", "Q191095"),
    p = c("P27", "P19", "P20"),
    label = TRUE,
    only_first = TRUE
  )
}
}
