% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_weather.R
\name{check_weather}
\alias{check_weather}
\title{Check weather records for data quality issues}
\usage{
check_weather(
  data,
  key_cols = c("mint", "maxt", "radn", "rain"),
  temp_range = c(-100, 100),
  radn_range = c(0, 50),
  rain_range = c(0, 500),
  stop_on_error = FALSE
)
}
\arguments{
\item{data}{A data.frame or tibble containing weather records with at minimum
a date column, latitude, longitude, and key weather variables (mint, maxt, radn, rain).}

\item{key_cols}{A character vector of column names to check for missing values
and extreme values. Default is c("mint", "maxt", "radn", "rain").}

\item{temp_range}{A numeric vector of length 2 specifying the acceptable range
for temperature values (mint, maxt). Default is c(-100, 100).}

\item{radn_range}{A numeric vector of length 2 specifying the acceptable range
for radiation values. Default is c(0, 50).}

\item{rain_range}{A numeric vector of length 2 specifying the acceptable range
for rainfall values. Default is c(0, 500).}

\item{stop_on_error}{Logical. If TRUE, the function will stop with an error
when issues are found. If FALSE, it will return a list of issues. Default is FALSE.}
}
\value{
If stop_on_error is FALSE, returns a list with the following components:
\item{is_valid}{Logical indicating if all checks passed}
\item{date_gaps}{Data frame of date gaps found, or NULL if none}
\item{missing_values}{Data frame summarizing missing values, or NULL if none}
\item{extreme_values}{Data frame of rows with extreme values, or NULL if none}
If stop_on_error is TRUE and issues are found, the function stops with an error message.
}
\description{
This function validates weather records for:
\itemize{
\item Continuous weather data (no gaps in dates)
\item No missing values in key columns (mint, maxt, radn, rain)
\item No extreme values (e.g., less than -100 or above 100 for temperature,
less than 0 for radiation and rain)
\item Latitude and longitude columns exist and contain a single non-NA value for all records
}
}
\examples{
file <- system.file("extdata/ppd_72150.met", package = "tidyweather")
records <- read_weather(file)
result <- check_weather(records)
if (result$is_valid) {
  print("Weather data passed all quality checks")
} else {
  print(result)
}
}
