% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_pop_fst.R
\name{pairwise_pop_fst}
\alias{pairwise_pop_fst}
\title{Compute pairwise population Fst}
\usage{
pairwise_pop_fst(
  .x,
  type = c("tidy", "pairwise"),
  by_locus = FALSE,
  by_locus_type = c("tidy", "matrix", "list"),
  method = c("Hudson", "Nei87", "WC84"),
  return_num_dem = FALSE,
  n_cores = bigstatsr::nb_cores()
)
}
\arguments{
\item{.x}{a grouped \code{\link{gen_tibble}} (as obtained by using \code{\link[dplyr:group_by]{dplyr::group_by()}})}

\item{type}{type of object to return One of "tidy" or "pairwise" for a
pairwise matrix of populations. Default is "tidy".}

\item{by_locus}{boolean, determining whether Fst should be returned by
locus(TRUE), or as a single genome wide value obtained by taking the ratio
of the mean numerator and denominator (FALSE, the default).}

\item{by_locus_type}{type of object to return. One of "tidy", "matrix" or
"list". Default is "tidy".}

\item{method}{one of 'Hudson', 'Nei87', and 'WC84'}

\item{return_num_dem}{returns a list of numerators and denominators for each
locus. This is useful for creating windowed estimates of Fst (as we need to
compute the mean numerator and denominator within each window). Default is
FALSE.}

\item{n_cores}{number of cores to be used, it defaults to
\code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}}
}
\value{
if \code{type=tidy}, a tibble of genome-wide pairwise Fst values with
each pairwise combination as a row if "by_locus=FALSE", else a list
including the tibble of genome-wide values as well as a matrix with
pairwise Fst by locus with loci as rows and and pairwise combinations as
columns. If \code{type=pairwise}, a matrix of genome-wide pairwise Fst values is
returned.
}
\description{
This function computes pairwise Fst. The following methods are implemented:
\itemize{
\item 'Hudson': Hudson's formulation, as derived in Bhatia et al (2013)
for diploids. This is the only method that can also be used with
pseudohaploid data.
\item 'Nei87' : Fst according to Nei (1987) - includes the correction for
heterozygosity when computing Ht (it uses the same formulation as in
\code{hierfstat::pairwise.neifst()}),
\item 'WC84' : Weir and Cockerham (1984), correcting for missing data (it uses
the same formulation as in \code{hierfstat::pairwise.WCfst()}).
}
}
\details{
For all formulae, the genome wide estimate is obtained by taking the ratio of
the mean numerators and denominators over all relevant SNPs.
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) withAutoprint(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("gen_tbl")

# For a basic global pairwise Fst calculation:
example_gt \%>\%
  group_by(population) \%>\%
  pairwise_pop_fst(method = "Nei87")

# With a pairwise matrix:
example_gt \%>\%
  group_by(population) \%>\%
  pairwise_pop_fst(method = "Nei87", type = "pairwise")

# To calculate Fst by locus:
example_gt \%>\%
  group_by(population) \%>\%
  pairwise_pop_fst(method = "Hudson", by_locus = TRUE)
\dontshow{\}) # examplesIf}
}
\references{
Bhatia G, Patterson N, Sankararaman S, Price AL. (2013)
Estimating and Interpreting FST: The Impact of Rare Variants. Genome
Research, 23(9):1514–1521.

Nei, M. (1987) Molecular Evolutionary Genetics. Columbia University Press

Weir, B. S., & Cockerham, C. C. (1984). Estimating F-statistics for the
analysis of population structure. Evolution, 38(6): 1358–1370.
}
\seealso{
\code{\link[hierfstat:pairwise.neifst]{hierfstat::pairwise.neifst()}}
}
