% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_pi.R
\name{loci_pi}
\alias{loci_pi}
\alias{loci_pi.tbl_df}
\alias{loci_pi.vctrs_bigSNP}
\alias{loci_pi.grouped_df}
\title{Estimate nucleotide diversity (pi) at each locus}
\usage{
loci_pi(.x, .col = "genotypes", n_cores, block_size, type, ...)

\method{loci_pi}{tbl_df}(
  .x,
  .col = "genotypes",
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(nrow(.x), 1),
  ...
)

\method{loci_pi}{vctrs_bigSNP}(
  .x,
  .col = "genotypes",
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(length(.x), 1),
  ...
)

\method{loci_pi}{grouped_df}(
  .x,
  .col = "genotypes",
  n_cores = bigstatsr::nb_cores(),
  block_size = bigstatsr::block_size(nrow(.x), 1),
  type = c("tidy", "list", "matrix"),
  ...
)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotypes} column of
a \code{\link{gen_tibble}} object), or a \code{\link{gen_tibble}}.}

\item{.col}{the column to be used when a tibble (or grouped tibble is passed
directly to the function). This defaults to "genotypes" and can only take
that value. There is no need for the user to set it, but it is included to
resolve certain tidyselect operations.}

\item{n_cores}{number of cores to be used, it defaults to
\code{\link[bigstatsr:reexports]{bigstatsr::nb_cores()}}}

\item{block_size}{maximum number of loci read at once.}

\item{type}{type of object to return, if using grouped method. One of "tidy",
"list", or "matrix". Default is "tidy".}

\item{...}{other arguments passed to specific methods, currently unused.}
}
\value{
a vector of frequencies, one per locus
}
\description{
Estimate nucleotide diversity (pi) at each locus, accounting for missing
values. This uses the formula: c_0 * c_1 / (n * (n-1) / 2)
}
\examples{
\dontshow{if (all(rlang::is_installed(c("RhpcBLASctl", "data.table")))) withAutoprint(\{ # examplesIf}
\dontshow{
data.table::setDTthreads(2)
RhpcBLASctl::blas_set_num_threads(2)
RhpcBLASctl::omp_set_num_threads(2)
}
example_gt <- load_example_gt("grouped_gen_tbl")

# For pi
example_gt \%>\% loci_pi()

# For pi per locus per population
example_gt \%>\%
  group_by(population) \%>\%
  loci_pi()
# alternatively, return a list of populations with their pi
example_gt \%>\%
  group_by(population) \%>\%
  loci_pi(type = "list")
# or a matrix with populations in columns and loci in rows
example_gt \%>\%
  group_by(population) \%>\%
  loci_pi(type = "matrix")
# or within reframe (not recommended, as it much less efficient
# than using it directly as shown above)
example_gt \%>\%
  group_by(population) \%>\%
  reframe(pi = loci_pi(genotypes))
\dontshow{\}) # examplesIf}
}
