% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstrat-facets.R
\name{facet_abundanceh}
\alias{facet_abundanceh}
\alias{facet_abundance}
\alias{facet_geochem_wraph}
\alias{facet_geochem_wrap}
\alias{facet_geochem_grid}
\alias{facet_geochem_gridh}
\title{Facet for relative abundance data}
\usage{
facet_abundanceh(
  taxon,
  grouping = NULL,
  rotate_facet_labels = 45,
  labeller = label_species,
  scales = "free_x",
  space = "free_x",
  dont_italicize = c("\\\\(.*?\\\\)", "spp?\\\\.", "-complex", "[Oo]ther"),
  ...
)

facet_abundance(
  taxon,
  grouping = NULL,
  rotate_facet_labels = 0,
  labeller = label_species,
  scales = "free_y",
  space = "free_y",
  dont_italicize = c("\\\\(.*?\\\\)", "spp?\\\\.", "-complex", "[Oo]ther"),
  ...
)

facet_geochem_wraph(
  param,
  grouping = NULL,
  rotate_axis_labels = 90,
  scales = "free_x",
  labeller = label_geochem,
  renamers = c(`^d([0-9]+)([HCNOS])$` = "paste(delta ^ \\\\1, \\\\2)", `^210Pb$` =
    "paste({}^210, Pb)", `^Pb210$` = "paste({}^210, Pb)"),
  units = character(0),
  default_units = NA_character_,
  ...
)

facet_geochem_wrap(
  param,
  grouping = NULL,
  scales = "free_y",
  labeller = label_geochem,
  renamers = c(`^d([0-9]+)([HCNOS])$` = "paste(delta ^ \\\\1, \\\\2)", `^210Pb$` =
    "paste({}^210, Pb)", `^Pb210$` = "paste({}^210, Pb)"),
  units = character(0),
  default_units = NA_character_,
  ...
)

facet_geochem_grid(
  param,
  grouping = NULL,
  rotate_axis_labels = 0,
  scales = "free_y",
  space = "fixed",
  labeller = label_geochem,
  renamers = c(`^d([0-9]+)([HCNOS])$` = "paste(delta ^ \\\\1, \\\\2)", `^210Pb$` =
    "paste({}^210, Pb)", `^Pb210$` = "paste({}^210, Pb)"),
  units = character(0),
  default_units = NA_character_,
  ...
)

facet_geochem_gridh(
  param,
  grouping = NULL,
  rotate_axis_labels = 90,
  scales = "free_x",
  space = "fixed",
  labeller = label_geochem,
  renamers = c(`^d([0-9]+)([HCNOS])$` = "paste(delta ^ \\\\1, \\\\2)", `^210Pb$` =
    "paste({}^210, Pb)", `^Pb210$` = "paste({}^210, Pb)"),
  units = character(0),
  default_units = NA_character_,
  ...
)
}
\arguments{
\item{taxon, param}{A call to \link[ggplot2:vars]{vars}, defining the column that identifies the taxon (parameter).}

\item{grouping}{A call to \link[ggplot2:vars]{vars}, identifying additional grouping columns}

\item{rotate_facet_labels, rotate_axis_labels}{Facet (axis) label rotation (degrees)}

\item{labeller}{Labeller to process facet names. Use \link{label_species} to italicize
species names, \link{label_geochem} to perform common formatting and units,
or \link[ggplot2:labellers]{label_value} to suppress.}

\item{space, scales}{Modify default scale freedom behaviour}

\item{dont_italicize}{Regular expressions that should not be italicized}

\item{...}{Passed to \link[ggplot2:facet_grid]{facet_grid} (abundance) or \link[ggplot2:facet_wrap]{facet_wrap} (geochem).}

\item{renamers}{Search and replace operations to perform in the form
search = replace. Replace text can (should) contain backreferences,
and will be parsed as an expression (see \link[grDevices:plotmath]{plotmath}). Use
NULL to suppress renaming.}

\item{units}{A named list of values = unit}

\item{default_units}{The default units to apply}
}
\value{
A subclass of \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} or \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.
}
\description{
Provides a number of modifications to the plot that are necessary for relative abundance plots
of a number of species. See \link{scale_x_abundance}, \link[ggplot2:facet_grid]{facet_grid},
\link[ggplot2:facet_grid]{facet_grid}, \link{label_species}, \link{label_geochem},
and \link{rotated_facet_labels} \link{rotated_axis_labels}
for examples of how to customize the default behaviour.
}
\examples{
library(ggplot2)

ggplot(keji_lakes_plottable, aes(x = rel_abund, y = depth)) +
  geom_col_segsh() +
  scale_y_reverse() +
  facet_abundanceh(vars(taxon), grouping = vars(location)) +
  labs(y = "Depth (cm)")

ggplot(keji_lakes_plottable, aes(y = rel_abund, x = depth)) +
  geom_col_segs() +
  scale_x_reverse() +
  facet_abundance(vars(taxon), grouping = vars(location)) +
  labs(x = "Depth (cm)")

ggplot(alta_lake_geochem, aes(x = value, y = depth)) +
  geom_lineh() +
  geom_point() +
  scale_y_reverse() +
  facet_geochem_wrap(vars(param), units = c(C = "\%", Cu = "ppm", Ti = "ppm"), nrow = 1) +
  labs(x = NULL, y = "Depth (cm)")

ggplot(alta_lake_geochem, aes(x = value, y = depth)) +
  geom_lineh() +
  geom_point() +
  scale_y_reverse() +
  facet_geochem_gridh(vars(param), units = c(C = "\%", Cu = "ppm", Ti = "ppm")) +
  labs(x = NULL, y = "Depth (cm)")

ggplot(alta_lake_geochem, aes(y = value, x = depth)) +
  geom_line() +
  geom_point() +
  scale_x_reverse() +
  facet_geochem_grid(vars(param), units = c(C = "\%", Cu = "ppm", Ti = "ppm")) +
  labs(y = NULL, x = "Depth (cm)")

}
