% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflows.R
\name{tl_transfer_learning}
\alias{tl_transfer_learning}
\title{Transfer Learning Workflow}
\usage{
tl_transfer_learning(
  data,
  formula,
  pretrain_method = "pca",
  supervised_method = "logistic",
  ...
)
}
\arguments{
\item{data}{Training data}

\item{formula}{Model formula}

\item{pretrain_method}{Pre-training method: "pca", "autoencoder"}

\item{supervised_method}{Supervised learning method}

\item{...}{Additional arguments}
}
\value{
A transfer learning model
}
\description{
Use unsupervised pre-training (e.g., autoencoder features) before supervised learning
}
\examples{
\donttest{
model <- tl_transfer_learning(iris, Species ~ ., pretrain_method = "pca")
}
}
