% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_wrds_ccm_links.R
\name{download_data_wrds_ccm_links}
\alias{download_data_wrds_ccm_links}
\title{Download CCM Links from WRDS}
\usage{
download_data_wrds_ccm_links(linktype = c("LU", "LC"), linkprim = c("P", "C"))
}
\arguments{
\item{linktype}{A character vector indicating the type of link to download.
The default is \code{c("LU", "LC")}, where "LU" stands for "Link Up" and "LC"
for "Link CRSP".}

\item{linkprim}{A character vector indicating the primacy of the link.
Default is \code{c("P", "C")}, where "P" indicates primary and "C" indicates
conditional links.}
}
\value{
A data frame with the columns \code{permno}, \code{gvkey}, \code{linkdt}, and
\code{linkenddt}, where \code{linkenddt} is the end date of the link, and missing end
dates are replaced with today's date.
}
\description{
This function downloads data from the WRDS CRSP/Compustat Merged (CCM) links
database. It allows users to specify the type of links (\code{linktype}) and the
primacy of the link (\code{linkprim}).
}
\examples{
\dontrun{
  ccm_links <- download_data_wrds_ccm_links(linktype = "LU", linkprim = "P")
}

}
