% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anycensus.R
\name{anycensus}
\alias{anycensus}
\title{Query Korean census data by admin code (province or municipality) and year}
\usage{
anycensus(
  year = 2020,
  codes = NULL,
  type = c("population", "housing", "tax", "mortality", "economy", "medicine",
    "migration", "environment", "welfare", "social security", "landuse"),
  level = c("adm2", "adm1"),
  aggregator = sum,
  geometry = FALSE,
  ...
)
}
\arguments{
\item{year}{integer(1). One of 2010, 2015, or 2020.}

\item{codes}{integer vector of admin codes (e.g. \code{c(11, 26)})
or character administrative area names (e.g. \code{c("Seoul", "Daejeon")}).}

\item{type}{character(1). "population", "housing", "tax", "economy",
"medicine", "migration", "environment", "mortality", "social security",
or "landuse".
Defaults to "population".}

\item{level}{character(1). "adm1" for province-level or
"adm2" for municipal-level. Defaults to "adm2".}

\item{aggregator}{function to aggregate values when \code{level = "adm1"}.}

\item{geometry}{logical(1). If \code{TRUE}, returns an \code{sf} object
with geometries attached. Defaults to \code{FALSE}.}

\item{...}{additional arguments passed to the \code{aggregator} function.
(e.g., \code{na.rm = TRUE}).}
}
\value{
A data.frame object containing census data
for the specified codes and year.
}
\description{
The function queries a long format census data frame
(\code{\link{censuskor}}) for specific administrative codes (if provided)
}
\note{
Using characters in \code{codes} has a side effect of returning
all rows in the dataset that match year and type.
The 'wide' table is returned with separate columns for each
\code{class1} and \code{class2} and \code{unit} (abbreviated whereof) combination.
}
\examples{
# Query mortality data for adm2_code 21 (Busan)
anycensus(codes = 21, type = "mortality")

# Query population data for adm1 "Seoul" or "Daejeon"
anycensus(codes = c("Seoul", "Daejeon"), type = "housing", year = 2015)

# Aggregate to adm1 level tax (province-level) using sum
anycensus(
  codes = c(11, 23, 31),
  type = "tax",
  year = 2020,
  level = "adm1",
  aggregator = sum,
  na.rm = TRUE
)
}
