% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variant_calling.R
\name{variant_call}
\alias{variant_call}
\title{Variant calling}
\usage{
variant_call(
  loci = NULL,
  in_dir,
  fw_pattern = "_F_filt.fastq.gz",
  rv_pattern = NULL,
  sample_locus = "(^[a-zA-Z0-9]*).([a-zA-Z0-9]*)",
  c_unmerged = FALSE,
  pool = FALSE,
  error_function = loessErrfun,
  multithread = FALSE,
  chim_rm = "consensus",
  ad = 1,
  maf = 0,
  omega_a_f = getDadaOpt()$OMEGA_A,
  omega_a_r = getDadaOpt()$OMEGA_A,
  band_size = getDadaOpt()$BAND_SIZE
)
}
\arguments{
\item{loci}{Character vector with loci to detect from 'sample_locus'
in sample names. If NULL, all loci detected according to the pattern in the
target directory are used.}

\item{in_dir}{Path to folder with truncated files.}

\item{fw_pattern}{Pattern matching files with F reads. It has to match
everything after locus name. eg see parenthesis in
"samplex_locus(_2_filt.fastq.gz)"}

\item{rv_pattern}{Pattern matching files with R reads. If left NULL,
single-end sequencing will be assumed.}

\item{sample_locus}{Patterns to extract from FASTQ file names.
Group 1 captures
sample name and group 2 captures locus name.
(DEFAULT: \verb{(^[a-zA-Z0-9]*)_([a-zA-Z0-9]*)}).
\verb{^[a-zA-Z0-9]*_[a-zA-Z0-9]*} will extract 'sample_locus'
from default naming convention \verb{sample_locus_[F|R]_fastq.gz}.}

\item{c_unmerged}{F/R sequences that were not merged in mergePairs are
concatenated using a stretch of 10 N's.}

\item{pool}{Passed to 'dada()'. Denoising is done in pooled samples
(T) or by sample (F).}

\item{error_function}{Use default 'loessErrfun' for regular Illumina quality
codification and 'loess_err_mod4' for binned NovaSeq qualities.}

\item{multithread}{T/F, passed to 'multithread' in 'dada'
and 'learnErrors()'.}

\item{chim_rm}{If FALSE, no chimera removal is performed.
If == "character", it is passed to
'method' in 'removeBimeraDenovo()' (DEFAULT = 'consensus').}

\item{ad}{Allele Depth. Passed to filter_variants.}

\item{maf}{Minimum Allele Frequency. Passed to filter_variants.}

\item{omega_a_f}{"OMEGA_A" passed to 'dada' in forward reads
(Default: getDadaOpt()$OMEGA_A).}

\item{omega_a_r}{"OMEGA_A" passed to 'dada' in reverse reads
(Default: getDadaOpt()$OMEGA_A).}

\item{band_size}{"BAND_SIZE" passed to 'dada'
(DEFAULT: getDadaOpt()$BAND_SIZE).}
}
\value{
tidy tibble with locus, sample, sequence, variant (name),
nt(sequence length), md5.
}
\description{
'variant_call' Call variants for multiple loci.
}
\details{
Allows single-end and paired-end data. Be careful with the use of
'c_unmerged'.
It  will trigger the 'justConcatenate' argument in 'mergePairs', and
10 N's will be used to concatenate non-overlapping F and R reads.
Use 'c_unmerged' carefully, as it will generate artificial
variant sequences.
Default is deactivated.
Variants are reformatted and to a "tibble" and filtered according to 'maf'
and 'ad', which are
added as attributes to output. Variables of output are 'sample', 'locus',
'sequence' (DNA sequence), 'variant' (name of variant),
'reads' (number of reads supporting that variant), 'nt' (sequence length),
'md5' (md5 checksum).
}
\examples{
# truncated fastq
truncated <-
 system.file("extdata", "truncated", package = "tidyGenR")
# variant calling
variant_call(in_dir = truncated)
}
