% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{generate_retail_calendar}
\alias{generate_retail_calendar}
\title{Generate a retail (4-4-5, 4-5-4, or 5-4-4) calendar mapping table}
\usage{
generate_retail_calendar(
  start_date,
  end_date,
  calendar_type,
  fiscal_year_start = 1,
  week_start = 7
)
}
\arguments{
\item{start_date}{Start date (Date or character YYYY-MM-DD)}

\item{end_date}{End date (Date or character YYYY-MM-DD)}

\item{calendar_type}{One of "445", "454", "544"}

\item{fiscal_year_start}{Integer 1-12, month the fiscal year starts nearest to}

\item{week_start}{Integer 1-7, day of week (1=Monday, 7=Sunday)}
}
\value{
A tibble with columns: date, year, quarter, month, week
}
\description{
Generate a retail (4-4-5, 4-5-4, or 5-4-4) calendar mapping table
}
\keyword{internal}
