% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/um.R
\name{fit.ssm}
\alias{fit.ssm}
\alias{fit}
\alias{fit.um}
\title{Estimation of the ARIMA model}
\usage{
\method{fit}{ssm}(
  mdl,
  z = NULL,
  updateSSM,
  param,
  show.iter = FALSE,
  tol = 1e-04,
  method = "BFGS",
  ...
)

fit(mdl, ...)

\method{fit}{um}(
  mdl,
  z = NULL,
  method = c("exact", "cond"),
  optim.method = "BFGS",
  show.iter = FALSE,
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{z}{a time series.}

\item{updateSSM}{user function to update the parameters of the SS model. 
The function must take a model object and a parameter vector as inputs and
return an updated model object.}

\item{param}{a numeric vector of named parameters passed to the 
\code{updateSSM} function.}

\item{show.iter}{logical value to show or hide the estimates at the
different iterations.}

\item{tol}{numeric. Tolerance to check if a root is close to one.}

\item{method}{Exact/conditional maximum likelihood.}

\item{...}{additional arguments for the \code{\link{optim}} function.}

\item{optim.method}{the \code{method} argument of the \code{optim}
function.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}
}
\value{
An object of class "ssm" with the estimated parameters.

An object of class "um" with the estimated parameters.
}
\description{
\code{fit} fits the univariate model to the time series z.
}
\note{
The \code{um} function estimates the corresponding ARIMA model when a time
series is provided. The \code{fit} function is useful to fit a model to
several time series, for example, in a Monte Carlo study.
}
\examples{
# Predefined local level model
ucm1 <- ucm(Nile, uc = "llm", fit = FALSE)
ucm1 <- fit(ucm1)
ucm1

# User defined local level model
ssm1 <- ssm(Nile, b = 1, C = 1, S = diag(c(1, 0.5)) )
param <- c(irr = var(Nile), lvl = var(diff(Nile)))
updateSSM <- function(mdl, param) {
mdl$S[1,1] <- param[1]
mdl$S[2,2] <- param[2]
mdl
}
fit(ssm1, updateSSM = updateSSM, param = param)

z <- AirPassengers
airl <- um(i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
airl <- fit(airl, z)
}
