#' textpress: A Lightweight and Versatile NLP Toolkit
#'
#' A lightweight NLP toolkit for R organized as a four-stage pipeline: fetch
#' (URLs from search/Wikipedia), read (content from URLs), process (split,
#' tokenize, index), and search (regex, BM25, vector similarity, dictionary).
#' Uses verb_noun naming for discoverability. Minimal dependencies; embeddings
#' are built elsewhere and passed in for semantic search.
#'
#' @importFrom utils head tail
#' @importFrom stats runif setNames
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
#' @importFrom data.table :=
#' @importFrom data.table .BY
#' @importFrom data.table .EACHI
#' @importFrom data.table .GRP
#' @importFrom data.table .I
#' @importFrom data.table .N
#' @importFrom data.table .NGRP
#' @importFrom data.table .SD
#' @importFrom data.table data.table
## usethis namespace: end
NULL
