% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{equivalent_rotation}
\alias{equivalent_rotation}
\title{Equivalent rotation}
\usage{
equivalent_rotation(x, fixed, rot)
}
\arguments{
\item{x}{Object of class \code{"data.frame"} containing the Euler poles of
plate rotations:
\describe{
\item{\code{plate.rot}}{Moving plate}
\item{\code{lat}, \code{lon}}{coordinates of Euler pole}
\item{\code{angle}}{Angle of rotation}
\item{\code{plate.fix}}{Fixed plate}
}}

\item{fixed}{plate that will be regarded as fixed. Has to be one out of
\code{x$plate.fix}}

\item{rot}{(optional) plate that will be regarded as rotating. Has to be one out of
\code{x$plate.rot}.}
}
\value{
sequence of plate rotations in new reference system. Same object
class as \code{x}
}
\description{
Transforms a sequence of rotations into a new reference system
}
\examples{
data(nuvel1) # load the NUVEL1 rotation parameters

# all nuvel1 rotation equivalent to fixed Africa:
equivalent_rotation(nuvel1, fixed = "af")
# relative plate motion between Eurasia and India:
equivalent_rotation(nuvel1, "eu", "in") # lat = 24.58, lon = 18.07, angle = 0.528
}
\seealso{
\code{\link[=relative_rotation]{relative_rotation()}}
}
