% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-access.R
\name{get_spotify_track_info}
\alias{get_spotify_track_info}
\title{Spotify track information}
\usage{
get_spotify_track_info(track_id, api_key = get_spotify_access_token())
}
\arguments{
\item{track_id}{The Spotify ID for a track.}

\item{api_key}{A Spotify access token, from
\code{\link[=get_spotify_access_token]{get_spotify_access_token()}}.}
}
\value{
A \link[tibble:tibble-package]{tibble} with track metadata, including:
\itemize{
\item \code{album_name}: The name of the album the track appears on (if relevant).
\item \code{track_name}: The name of the track.
\item \code{artist}: The artist of the track.
\item \code{featuring}: The artist(s) featured on the track (if relevant).
\item \code{duration_ms}: Duration of the track in milliseconds.
\item \code{explicit}: Logical. Does the track contain explicit lyrics (\code{TRUE}) or
not (\code{FALSE}).
}
}
\description{
Access the Spotify API to get metadata for audio tracks.
}
\examples{
\dontshow{if (taylor_examples()) withAutoprint(\{ # examplesIf}
# So High School
get_spotify_track_info(track_id = "7Mts0OfPorF4iwOomvfqn1")
\dontshow{\}) # examplesIf}
}
\seealso{
Other API access: 
\code{\link{get_reccobeats_audio_features}()},
\code{\link{get_soundstat_audio_features}()}
}
\concept{API access}
