% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_functions.R
\name{search_duplicates}
\alias{search_duplicates}
\title{Search for duplicate files in a directory}
\usage{
search_duplicates(dir_path, verbose = TRUE)
}
\arguments{
\item{dir_path}{A character string representing the path to the directory to search for duplicates}

\item{verbose}{Logical. If TRUE, displays a list of duplicate files found (default is TRUE)}
}
\value{
A data frame containing information about duplicate files (invisible by default)
}
\description{
This function searches for duplicate files within a directory based on their content.
Duplicate files are identified by having either the same filename and same content
or different filenames but same content.
}
\examples{
# Search for duplicate files in a directory

\donttest{
e <- toy_dirs()
search_duplicates(dir_path = e$left)
}
}
