
split_sumerian <- function(x) {
  # Regex für sumerische Zeichen

  # a) Kleinbuchstaben a-z, ĝ, š, ḫ, optional gefolgt von Zahl
  lowercase <- "[a-z\u011d\u0161\u1e2b\u00e1\u00e9\u00ed\u00fa\u00e0\u00e8\u00ec\u00f9]+[0-9]*"

  # b) Großbuchstaben, optional gefolgt von Großbuchstaben, Zahlen, × oder +
  uppercase <- "[A-Z\u0160\u011c\u1e2a](?:[A-Z\u0160\u011c\u1e2a0-9\u00d7+/%\u00b7]|gunu|tenu|\u0161e\u0161ig)*"

  # Verbiete "N" und "X", wenn danach kein weiteres zulässiges Zeichen kommt.
  uppercase <- paste0("(?![NX](?![A-Z\u0160\u011c\u1e2a0-9\u00d7+/%\u00b7]))",uppercase)

  # c) Keilschrift: Unicode U+12000 bis U+123FF

  cuneiform <- "[\\x{12000}-\\x{12500}\u2205]"
  cuneiform <- paste0(cuneiform, "|\u27E8", lowercase, "\u27E9|\u27E8", uppercase, "\u27E9")

  # Kombiniertes Pattern
  pattern <- paste0("(", cuneiform, "|", lowercase, "|", uppercase, ")")

  # Finde alle Matches mit Positionen
  matches <- str_locate_all(x, pattern)[[1]]

  # Sonderfall: keine Matches
  if (nrow(matches) == 0) {
    return(list(signs = character(0), separators = x, type=integer(0)))
  }

  # Extrahiere die sumerischen Zeichen
  signs <- str_sub(x, matches[, "start"], matches[, "end"])

  # Berechne die Trennzeichen (n+1 Elemente für n Zeichen)
  n <- length(signs)
  separators <- character(n + 1)

  # Vor dem ersten Zeichen
  if (matches[1, "start"] > 1) {
    separators[1] <- str_sub(x, 1, matches[1, "start"] - 1)
  }

  # Zwischen den Zeichen
  if (n > 1) {
    for (i in 1:(n - 1)) {
      start_sep <- matches[i, "end"] + 1
      end_sep <- matches[i + 1, "start"] - 1
      if (start_sep <= end_sep) {
        separators[i + 1] <- str_sub(x, start_sep, end_sep)
      }else{
        separators[i + 1]<-"-"
      }
    }
  }

  # Nach dem letzten Zeichen
  if (matches[n, "end"] < str_length(x)) {
    separators[n + 1] <- str_sub(x, matches[n, "end"] + 1, str_length(x))
  }


  # Bestimme den Typ für jedes Zeichen
  # Vollständige Patterns mit Anfang/Ende-Ankern
  pattern_lowercase <- paste0("^", lowercase, "$")
  pattern_uppercase <- paste0("^", uppercase, "$")
  pattern_cuneiform <- paste0("^", cuneiform, "$")

  types <- integer(length(signs))
  types[str_detect(signs, pattern_lowercase)] <- 1L
  types[str_detect(signs, pattern_uppercase)] <- 2L
  types[str_detect(signs, pattern_cuneiform)] <- 3L


  list(signs = signs, separators = separators, types=types)
}
