% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_transformation.R
\name{compute_bcf_posterior_interval}
\alias{compute_bcf_posterior_interval}
\title{Compute BCF Posterior Credible Intervals}
\usage{
compute_bcf_posterior_interval(
  model_object,
  terms,
  level = 0.95,
  scale = "linear",
  X = NULL,
  Z = NULL,
  propensity = NULL,
  rfx_group_ids = NULL,
  rfx_basis = NULL
)
}
\arguments{
\item{model_object}{A fitted BCF model object of class \code{bcfmodel}.}

\item{terms}{A character string specifying the model term(s) for which to compute intervals. Options for BCF models are \code{"prognostic_function"}, \code{"mu"}, \code{"cate"}, \code{"tau"}, \code{"variance_forest"}, \code{"rfx"}, or \code{"y_hat"}. Note that \code{"mu"} is only different from \code{"prognostic_function"} if random effects are included with a model spec of \code{"intercept_only"} or \code{"intercept_plus_treatment"} and \code{"tau"} is only different from \code{"cate"} if random effects are included with a model spec of \code{"intercept_plus_treatment"}.}

\item{level}{A numeric value between 0 and 1 specifying the credible interval level (default is 0.95 for a 95\% credible interval).}

\item{scale}{(Optional) Scale of mean function predictions. Options are "linear", which returns predictions on the original scale of the mean forest / RFX terms, and "probability", which transforms predictions into a probability of observing \code{y == 1}. "probability" is only valid for models fit with a probit outcome model. Default: "linear".}

\item{X}{(Optional) A matrix or data frame of covariates at which to compute the intervals. Required if the requested term depends on covariates (e.g., prognostic forest, CATE forest, variance forest, or overall predictions).}

\item{Z}{(Optional) A vector or matrix of treatment assignments. Required if the requested term is \code{"y_hat"} (overall predictions).}

\item{propensity}{(Optional) A vector or matrix of propensity scores. Required if the underlying model depends on user-provided propensities.}

\item{rfx_group_ids}{An optional vector of group IDs for random effects. Required if the requested term includes random effects.}

\item{rfx_basis}{An optional matrix of basis function evaluations for random effects. Required if the requested term includes random effects.}
}
\value{
A list containing the lower and upper bounds of the credible interval for the specified term. If multiple terms are requested, a named list with intervals for each term is returned.
}
\description{
Compute posterior credible intervals for specified terms from a fitted BCF model. Supports intervals for prognostic forests, CATE forests, variance forests, random effects, and overall mean outcome predictions.
}
\examples{
n <- 100
p <- 5
X <- matrix(rnorm(n * p), nrow = n, ncol = p)
pi_X <- pnorm(0.5 * X[,1])
Z <- rbinom(n, 1, pi_X)
mu_X <- X[,1]
tau_X <- 0.25 * X[,2]
y <- mu_X + tau_X * Z + rnorm(n)
bcf_model <- bcf(X_train = X, Z_train = Z, y_train = y,
                 propensity_train = pi_X)
intervals <- compute_bcf_posterior_interval(
 model_object = bcf_model,
 terms = c("prognostic_function", "cate"),
 X = X,
 Z = Z,
 propensity = pi_X,
 level = 0.90
)
}
