% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{CppJson}
\alias{CppJson}
\title{JSON C++ Object Wrapper}
\description{
Wrapper around a C++ \code{nlohmann::json} object

This class is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{json_ptr}}{External pointer to a C++ nlohmann::json object}

\item{\code{num_forests}}{Number of forests in the nlohmann::json object}

\item{\code{forest_labels}}{Names of forest objects in the overall nlohmann::json object}

\item{\code{num_rfx}}{Number of random effects terms in the nlohman::json object}

\item{\code{rfx_container_labels}}{Names of rfx container objects in the overall nlohmann::json object}

\item{\code{rfx_mapper_labels}}{Names of rfx label mapper objects in the overall nlohmann::json object}

\item{\code{rfx_groupid_labels}}{Names of rfx group id objects in the overall nlohmann::json object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CppJson-new}{\code{CppJson$new()}}
\item \href{#method-CppJson-add_forest}{\code{CppJson$add_forest()}}
\item \href{#method-CppJson-add_random_effects}{\code{CppJson$add_random_effects()}}
\item \href{#method-CppJson-add_scalar}{\code{CppJson$add_scalar()}}
\item \href{#method-CppJson-add_integer}{\code{CppJson$add_integer()}}
\item \href{#method-CppJson-add_boolean}{\code{CppJson$add_boolean()}}
\item \href{#method-CppJson-add_string}{\code{CppJson$add_string()}}
\item \href{#method-CppJson-add_vector}{\code{CppJson$add_vector()}}
\item \href{#method-CppJson-add_integer_vector}{\code{CppJson$add_integer_vector()}}
\item \href{#method-CppJson-add_string_vector}{\code{CppJson$add_string_vector()}}
\item \href{#method-CppJson-add_list}{\code{CppJson$add_list()}}
\item \href{#method-CppJson-add_string_list}{\code{CppJson$add_string_list()}}
\item \href{#method-CppJson-get_scalar}{\code{CppJson$get_scalar()}}
\item \href{#method-CppJson-get_integer}{\code{CppJson$get_integer()}}
\item \href{#method-CppJson-get_boolean}{\code{CppJson$get_boolean()}}
\item \href{#method-CppJson-get_string}{\code{CppJson$get_string()}}
\item \href{#method-CppJson-get_vector}{\code{CppJson$get_vector()}}
\item \href{#method-CppJson-get_integer_vector}{\code{CppJson$get_integer_vector()}}
\item \href{#method-CppJson-get_string_vector}{\code{CppJson$get_string_vector()}}
\item \href{#method-CppJson-get_numeric_list}{\code{CppJson$get_numeric_list()}}
\item \href{#method-CppJson-get_string_list}{\code{CppJson$get_string_list()}}
\item \href{#method-CppJson-return_json_string}{\code{CppJson$return_json_string()}}
\item \href{#method-CppJson-save_file}{\code{CppJson$save_file()}}
\item \href{#method-CppJson-load_from_file}{\code{CppJson$load_from_file()}}
\item \href{#method-CppJson-load_from_string}{\code{CppJson$load_from_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-new"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-new}{}}}
\subsection{Method \code{new()}}{
Create a new CppJson object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{CppJson} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_forest"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_forest}{}}}
\subsection{Method \code{add_forest()}}{
Convert a forest container to json and add to the current \code{CppJson} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_forest(forest_samples)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{forest_samples}}{\code{ForestSamples} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_random_effects"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_random_effects}{}}}
\subsection{Method \code{add_random_effects()}}{
Convert a random effects container to json and add to the current \code{CppJson} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_random_effects(rfx_samples)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rfx_samples}}{\code{RandomEffectSamples} R class}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_scalar"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_scalar}{}}}
\subsection{Method \code{add_scalar()}}{
Add a scalar to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_scalar(field_name, field_value, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_value}}{Numeric value of the field to be added to json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_integer"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_integer}{}}}
\subsection{Method \code{add_integer()}}{
Add a scalar to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_integer(field_name, field_value, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_value}}{Integer value of the field to be added to json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_boolean"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_boolean}{}}}
\subsection{Method \code{add_boolean()}}{
Add a boolean value to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_boolean(field_name, field_value, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_value}}{Numeric value of the field to be added to json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_string"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_string}{}}}
\subsection{Method \code{add_string()}}{
Add a string value to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_string(field_name, field_value, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_value}}{Numeric value of the field to be added to json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_vector}{}}}
\subsection{Method \code{add_vector()}}{
Add a vector to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_vector(field_name, field_vector, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_vector}}{Vector to be stored in json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_integer_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_integer_vector}{}}}
\subsection{Method \code{add_integer_vector()}}{
Add an integer vector to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_integer_vector(field_name, field_vector, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_vector}}{Vector to be stored in json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_string_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_string_vector}{}}}
\subsection{Method \code{add_string_vector()}}{
Add an array to the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_string_vector(field_name, field_vector, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_vector}}{Character vector to be stored in json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which to place the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_list"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_list}{}}}
\subsection{Method \code{add_list()}}{
Add a list of vectors (as an object map of arrays) to the json object under the name "field_name"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_list(field_name, field_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_list}}{List to be stored in json}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-add_string_list"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-add_string_list}{}}}
\subsection{Method \code{add_string_list()}}{
Add a list of vectors (as an object map of arrays) to the json object under the name "field_name"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$add_string_list(field_name, field_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{field_list}}{List to be stored in json}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_scalar"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_scalar}{}}}
\subsection{Method \code{get_scalar()}}{
Retrieve a scalar value from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_scalar(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_integer"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_integer}{}}}
\subsection{Method \code{get_integer()}}{
Retrieve a integer value from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_integer(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_boolean"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_boolean}{}}}
\subsection{Method \code{get_boolean()}}{
Retrieve a boolean value from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_boolean(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_string"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_string}{}}}
\subsection{Method \code{get_string()}}{
Retrieve a string value from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_string(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_vector}{}}}
\subsection{Method \code{get_vector()}}{
Retrieve a vector from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_vector(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_integer_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_integer_vector}{}}}
\subsection{Method \code{get_integer_vector()}}{
Retrieve an integer vector from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_integer_vector(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_string_vector"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_string_vector}{}}}
\subsection{Method \code{get_string_vector()}}{
Retrieve a character vector from the json object under the name "field_name" (with optional subfolder "subfolder_name")
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_string_vector(field_name, subfolder_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be accessed from json}

\item{\code{subfolder_name}}{(Optional) Name of the subfolder / hierarchy under which the field is stored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_numeric_list"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_numeric_list}{}}}
\subsection{Method \code{get_numeric_list()}}{
Reconstruct a list of numeric vectors from the json object stored under "field_name"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_numeric_list(field_name, key_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{key_names}}{Vector of names of list elements (each of which is a vector)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-get_string_list"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-get_string_list}{}}}
\subsection{Method \code{get_string_list()}}{
Reconstruct a list of string vectors from the json object stored under "field_name"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$get_string_list(field_name, key_names)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field to be added to json}

\item{\code{key_names}}{Vector of names of list elements (each of which is a vector)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-return_json_string"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-return_json_string}{}}}
\subsection{Method \code{return_json_string()}}{
Convert a JSON object to in-memory string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$return_json_string()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
JSON string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-save_file"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-save_file}{}}}
\subsection{Method \code{save_file()}}{
Save a json object to file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$save_file(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{String of filepath, must end in ".json"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-load_from_file"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-load_from_file}{}}}
\subsection{Method \code{load_from_file()}}{
Load a json object from file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$load_from_file(filename)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{String of filepath, must end in ".json"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CppJson-load_from_string"></a>}}
\if{latex}{\out{\hypertarget{method-CppJson-load_from_string}{}}}
\subsection{Method \code{load_from_string()}}{
Load a json object from string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CppJson$load_from_string(json_string)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json_string}}{JSON string dump}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
}
}
