% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table2.R
\name{table2}
\alias{table2}
\title{Enhanced alternative to table()}
\arguments{
\item{...}{same arguments as \code{\link[base]{table}}, plus the arguments shown below}

\item{prop}{report a table with:
\itemize{
  \item \code{prop="all"}: Proportions for full table (each cell / total)
  \item \code{prop="row"}: Proportions by row  ('rows' also accepted)
  \item \code{prop="col"}: Proportions by columns ('cols', 'column', 'columns' also accepted)
}}

\item{digits}{Number of decimal values to show for proportions}

\item{chi}{Logical. If \code{TRUE}, performs a chi-square test on frequency table,
reports results in APA format}

\item{correct}{Logical. If \code{TRUE}, applies Yates' continuity correction 
for 2x2 tables in the chi-square test. Default is \code{FALSE} (no correction).}
}
\value{
A list (object of class "table2") with the following components:
  \itemize{
    \item \code{freq}: frequency table 
    \item \code{prop}: proportions table 
    \item \code{chisq}: chi-square test  
  }
}
\description{
The function \code{\link[base]{table}} does not show variable 
 names when tabulating from a dataframe, requires running another
 function, \code{\link[base]{prop.table}},  to tabulate proportions 
 and yet another function, \code{\link[stats]{chisq.test}} to test difference of 
 proportions.  \code{table2} does what those three functions do, producing easier to 
 read output, and always shows variable names.
}
\examples{
# Create example data
df <- data.frame(
  group = c("A", "A", "B", "B", "A"),
  status = c("X", "Y", "X", "Y", "X")
)

# Enhanced table with variable names (2 variables)
table2(df$group, df$status)

# Enhanced table with variable names (3 variables)
df3 <- data.frame(
  x = c("A", "A", "B", "B"),
  y = c("X", "Y", "X", "Y"),
  z = c("high", "low", "high", "low")
)
table2(df3$x, df3$y, df3$z)

# Table with proportions
table2(df$group, df$status, prop = 'all')  # Overall proportions
table2(df$group, df$status, prop = 'row')  # Row proportions
table2(df$group, df$status, prop = 'col')  # Column proportions

# Table with chi-square test
table2(df$group, df$status, chi = TRUE,prop='all')

}
