% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resize_images.R
\name{resize_images}
\alias{resize_images}
\title{Resize Images}
\usage{
resize_images(path, width)
}
\arguments{
\item{path}{Character string. Path to a folder containing image files, or path to a single image file.}

\item{width}{Numeric vector. Target width(s) in pixels for the output PNG files.
Can be a single value (recycled for all files) or a vector matching the number
of files found.}
}
\value{
Invisibly returns TRUE on success.
}
\description{
Saves images to PNG with a specified width. As input it accepts (SVG, PDF, EPS, JPG, JPEG, TIF, TIFF, BMP, PNG)
Saves to subdirectory '/resized' within input folder (or same directory as file if input is a single file)
}
\details{
This function:
\itemize{
  \item Searches for image files with extensions: svg, pdf, eps, jpg, jpeg, tif, tiff, bmp, png
  \item Creates a "resized" subfolder in the target directory if it doesn't exist
  \item Converts each file to PNG format at the specified width(s)
  \item Saves output files as: \code{originalname_width.png} in the resized subfolder
}

Supported input formats:
\itemize{
  \item Vector graphics: SVG, PDF, EPS (rasterized using rsvg/magick)
  \item Raster images: JPG, JPEG, TIF, TIFF, BMP, PNG
}
}
\note{
Dependencies required: \code{rsvg}, \code{magick}, and \code{tools} (base R).
SVG files are rasterized using \code{rsvg::rsvg()}, while PDF/EPS and other
formats are handled by \code{magick::image_read()}.
}
\examples{
\donttest{
# Create a temporary PNG file and resize it
tmp_png <- tempfile(fileext = ".png")
grDevices::png(tmp_png, width = 400, height = 300)
old_par <- graphics::par(no.readonly = TRUE)
graphics::par(mar = c(2, 2, 1, 1))
graphics::plot(1:2, 1:2, type = "n")
grDevices::dev.off()
graphics::par(old_par)
resize_images(tmp_png, width = 80)
}

}
