% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clear.R
\name{clear}
\alias{clear}
\title{Clear All: Environment, Console, and Graphics}
\usage{
clear(envir = parent.frame())
}
\arguments{
\item{envir}{The environment to clear. Defaults to the calling environment.
The global environment is not modified by this function.}
}
\value{
Invisibly returns NULL. Prints a colored confirmation message.
}
\description{
Clear All: Environment, Console, and Graphics
}
\details{
This function performs three cleanup operations:
\itemize{
  \item \strong{Environment}: Removes all objects from the specified environment
  \item \strong{Console}: Clears the console screen (only in interactive sessions)
  \item \strong{Graphics}: Closes all open graphics devices (except the null device)
}

\strong{Warning}: This function deletes all objects in the specified
environment. Save anything that you wish to keep before running.
}
\examples{
\donttest{
# Clear a temporary environment (safe for examples)
tmp_env <- new.env()
tmp_env$x <- 1:10
tmp_env$y <- rnorm(10)
clear(tmp_env)
}

}
