% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.biphi}
\alias{ci.biphi}
\title{Confidence interval for a biserial-phi correlation}
\usage{
ci.biphi(alpha, f1, f2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of participants in group 1 who have the attribute}

\item{f2}{number of participants in group 2 who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of biserial-phi correlation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population biserial-phi correlation
using a transformation of a confidence interval for an odds ratio with .5
added to each cell frequency. This measure of association assumes the group
variable is naturally dichotomous and the response variable is artificially
dichotomous.

For more details, see Section 3.4 of Bonett (2021, Volume 3)
}
\examples{
ci.biphi(.05, 34, 22, 50, 50)

# Should return:
#  Estimate     SE    LL    UL
#     0.275 0.1075 0.049 0.464


}
\references{
\insertRef{Ulrich2004}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
