% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_stvar_int}
\alias{simulate_stvar_int}
\title{INTERNAL Simulate method for class 'stvar' objects}
\usage{
simulate_stvar_int(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  init_values = NULL,
  init_regime,
  ntimes = 1,
  use_stat_for_Gaus = FALSE,
  burn_in = 1000,
  exo_weights = NULL,
  drop = TRUE,
  girf_pars = NULL
)
}
\arguments{
\item{object}{an object of class \code{'stvar'}.}

\item{nsim}{number of observations to be simulated.}

\item{seed}{set seed for the random number generator?}

\item{...}{currently not in use.}

\item{init_values}{a size \eqn{(p\times d)} matrix specifying the initial values, where d is the number
of time series in the system. The \strong{last} row will be used as initial values for the first lag,
the second last row for second lag etc. If not specified, initial values will be drawn from
the regime specified in \code{init_regimes}.}

\item{init_regime}{an integer in \eqn{1,...,M} specifying the regime from which
the initial values should be generated from (using a simulation procedure with a burn-in period).
For models with Gaussian conditional distribution, it is also possible to generate the starting
values from the stationary distribution of a regime. See the details section.}

\item{ntimes}{how many sets of simulations should be performed?}

\item{use_stat_for_Gaus}{if \code{TRUE} and \code{cond_dist=="Gaussian"}, uses the stationary distribution
of a regime to generate the initial values for the simulation. Note that if stationary distribution is used,
unlike with out simulation procedure, it is not guaranteed that the regime of interest has high transition weights
at the given points of time. Note that if the model allows for unstable estimates (\code{stvar$allow_unstab=TRUE}),
simulation procedure is always used.}

\item{burn_in}{Burn-in period for simulating initial values from a regime when \code{cond_dist!="Gaussian"}.
See the details section.}

\item{exo_weights}{if \code{weight_function="exogenous"}, provide a size \eqn{(nsim \times M)} matrix of exogenous
transition weights for the regimes: \code{[t, m]} for a time \eqn{t} and regime \eqn{m} weight. Ignored
if \code{weight_function!="exogenous"}.}

\item{drop}{if \code{TRUE} (default) then the components of the returned list are coerced to lower dimension if
\code{ntimes==1}, i.e., \code{$sample} and \code{$transition_weights} will be matrices, and \code{$component}
 will be vector.}

\item{girf_pars}{This argument is used internally in the estimation of generalized impulse response functions.
Specifying something else than null to it will change how the function behaves. Should be a list with following elements
\describe{
  \item{shock_numb}{The number of the shock to be used in the GIRF.}
  \item{shock_size}{The size of the shock to be used in the GIRF.}
  \item{cfact_pars}{A list with the following elements (only for simulating counterfactuals):
    \describe{
      \item{cfact_metatype}{The metatype of the counterfactual, \code{c("counterfactual_fore", "counterfactual_girf").}}
      \item{cfact_type}{The type of the counterfactual, \code{c("fixed_path", "muted_response").}}
      \item{policy_var}{The variable to be used as the policy variable.}
      \item{mute_var}{The variable to be used as the mute variable.}
      \item{cfact_start}{The start of the counterfactual period.}
      \item{cfact_end}{The end of the counterfactual period.}
    }
  }
}}
}
\value{
Returns a list containing the simulation results. If \code{drop==TRUE} and \code{ntimes==1} (default),
  contains the following entries:
  \item{sample}{a size (\code{nsim}\eqn{\times d}) matrix containing the simulated time series.}
  \item{transition weights}{a size (\code{nsim}\eqn{\times M}) matrix containing the transition weights corresponding
        to the simulated sample.}
  Otherwise, returns a list with the following entries:
  \item{sample}{a size (\code{nsim}\eqn{\times d\times}\code{ntimes}) array containing the samples: the dimension
     \code{[t, , ]} is the time index, the dimension \code{[, d, ]} indicates the marginal time series, and the dimension
     \code{[, , i]} indicates the i:th set of simulations.}
  \item{transition_weights}{a size (\code{nsim}\eqn{\times M \times}\code{ntimes}) array containing the transition weights
     corresponding to the sample: the dimension \code{[t, , ]} is the time index, the dimension \code{[, m, ]} indicates the
     regime, and the dimension \code{[, , i]} indicates the i:th set of simulations.}
}
\description{
\code{simulate_stvar_int} is an internal simulate function for class 'stvar' objects.
}
\details{
When using \code{init_regime} to simulate the initial values from a given regime, we employ the following simulation
  procedure to obtain the initial values (unless \code{use_stat_for_Gaus=TRUE} and Gaussian model is considered).
  First, we set the initial values to the unconditional mean of the specified regime. Then,
  we simulate a large number observations from that regime as specified in the argument \code{burn_in}. Then, we simulate
  \eqn{p + 100} observations more after the burn in period, and for the \eqn{100} observations calculate the transition
  weights for them and take the consecutive \eqn{p} observations that yield the highest transition weight for the given regime.
  For models with exogenous transition weights, takes just the last \eqn{p} observations after the burn-in period.

  The argument \code{ntimes} is intended for forecasting, which is used by the predict method (see \code{?predict.stvar}).
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation.
     \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{International Economic Review}, \strong{35}:3, 407-414.
   \item Lanne M., Virolainen S. 2025. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks.
      \emph{Journal of Economic Dynamics and Control}, \strong{178}, 105162.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Kilian L., Lütkepohl H. 20017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2025. Identification by non-Gaussianity in structural
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{predict.stvar}},\code{\link{GIRF}}, \code{\link{GFEVD}},  \code{\link{fitSTVAR}},
  \code{\link{fitSSTVAR}} \code{\link{STVAR}}
}
\keyword{internal}
