% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_sql.R
\name{tidy.lm_sql_result}
\alias{tidy.lm_sql_result}
\title{Tidy an lm_sql_result}
\usage{
\method{tidy}{lm_sql_result}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An `lm_sql_result` object.}

\item{conf.int}{Logical. If `TRUE`, include confidence interval columns
`conf.low` and `conf.high`. Defaults to `FALSE`.}

\item{conf.level}{Confidence level for the interval. Defaults to `0.95`.}

\item{...}{Not used.}
}
\value{
A tibble with columns `term`, `estimate`, `std.error`, `statistic`,
  and `p.value`. If `conf.int = TRUE`, also `conf.low` and `conf.high`.
}
\description{
Extract a tidy tibble of per-term coefficient statistics from
  a fitted SQL linear model.
}
\details{
Returns one row per model term with the estimate, standard error,
  t-statistic, and p-value. When `conf.int = TRUE`, confidence intervals
  are computed using the t-distribution with `df_residual` degrees of
  freedom.
}
