% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_sql.R
\name{lm_sql_result}
\alias{lm_sql_result}
\title{Result object for SQL-backed Linear Model}
\usage{
lm_sql_result(
  coefficients = integer(0),
  std_error = integer(0),
  sigma = numeric(0),
  r_squared = numeric(0),
  adj_r_squared = numeric(0),
  f_statistic = integer(0),
  f_p_value = integer(0),
  logLik = numeric(0),
  AIC = numeric(0),
  BIC = numeric(0),
  nobs = numeric(0),
  df_residual = numeric(0),
  df_model = numeric(0),
  statistic = integer(0),
  p_value = integer(0),
  call = NULL,
  term_expressions = NULL
)
}
\description{
An S7 class that stores the complete results of a SQL-backed
  linear regression fitted by [lm_sql()].
}
\details{
This class is not called directly by users. It is created
  internally by [lm_sql()] and returned as the model object. It stores
  fitted coefficients, standard errors, t-statistics, p-values, and
  model-level summaries (R-squared, F-statistic, AIC, BIC, etc.). The
  `term_expressions` property holds named R expressions for each predictor,
  which are used by the [orbital.lm_sql_result()] method to generate
  in-database prediction expressions.
}
\keyword{internal}
