% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_vif.R
\name{.vif_to_df}
\alias{.vif_to_df}
\title{Convert VIF values to data frame}
\usage{
.vif_to_df(x)
}
\arguments{
\item{x}{Data frame with numeric predictors for which to compute VIF values.}
}
\value{
Data frame with two columns: \code{variable} (character, variable names) and \code{vif} (numeric, VIF scores), sorted by VIF in descending order.
}
\description{
Computes variance inflation factors for all variables in a data frame and returns them in a tidy format, sorted by VIF in descending order.
}
\seealso{
Other utilities: 
\code{\link{auc}()},
\code{\link{beowulf_cluster}()},
\code{\link{objects_size}()},
\code{\link{optimization_function}()},
\code{\link{prepare_importance_spatial}()},
\code{\link{rescale_vector}()},
\code{\link{root_mean_squared_error}()},
\code{\link{setup_parallel_execution}()},
\code{\link{standard_error}()},
\code{\link{statistical_mode}()},
\code{\link{thinning}()},
\code{\link{thinning_til_n}()}
}
\concept{utilities}
