% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_vif.R
\name{auto_vif}
\alias{auto_vif}
\title{Multicollinearity reduction via Variance Inflation Factor}
\usage{
auto_vif(x = NULL, preference.order = NULL, vif.threshold = 5, verbose = TRUE)
}
\arguments{
\item{x}{Data frame with predictors, or a \code{variable_selection} object from \code{\link[=auto_cor]{auto_cor()}}. Default: \code{NULL}.}

\item{preference.order}{Character vector specifying variable preference order. Does not need to include all variables in \code{x}. If \code{NULL}, column order is used. Default: \code{NULL}.}

\item{vif.threshold}{Numeric (recommended: 2.5 to 10). Maximum allowed VIF among selected variables. Higher values allow more collinearity. Default: \code{5}.}

\item{verbose}{Logical. If \code{TRUE}, prints messages about operations and removed variables. Default: \code{TRUE}}
}
\value{
List with class \code{variable_selection} containing:
\itemize{
\item \code{vif}: Data frame with selected variable names and their VIF scores.
\item \code{selected.variables}: Character vector of selected variable names.
\item \code{selected.variables.df}: Data frame containing selected variables.
}
}
\description{
Filters predictors using sequential evaluation of variance inflation factors. Predictors are ranked by user preference (or column order) and evaluated sequentially. Each candidate is added to the selected pool only if the maximum VIF of all predictors (candidate plus already-selected) does not exceed the threshold.
}
\details{
The algorithm follows these steps:
\enumerate{
\item Rank predictors by \code{preference.order} (or use column order if NULL).
\item Initialize selection pool with first predictor.
\item For each remaining candidate:
\itemize{
\item Compute VIF for candidate plus all selected predictors.
\item If max VIF equal or lower than \code{vif.threshold}, add candidate to selected pool.
\item Otherwise, skip candidate.
}
\item Return selected predictors with their VIF values.
}

\strong{Data cleaning}: Variables in \code{preference.order} not found in \code{colnames(x)} are silently removed. Non-numeric columns are removed with a warning. Rows with NA values are removed via \code{\link[=na.omit]{na.omit()}}. Zero-variance columns trigger a warning but are not removed.

This function can be chained with \code{\link[=auto_cor]{auto_cor()}} through pipes (see examples).
}
\examples{
data(
  plants_df,
  plants_predictors
)

y <- auto_vif(
  x = plants_df[, plants_predictors]
)

y$selected.variables
y$vif
head(y$selected.variables.df)

}
\seealso{
\code{\link[=auto_cor]{auto_cor()}}

Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{case_weights}()},
\code{\link{default_distance_thresholds}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{is_binary}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
