% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nimble_model.R
\name{run_nimble_model}
\alias{run_nimble_model}
\title{Run NIMBLE Model with Diagnostics}
\usage{
run_nimble_model(
  constants,
  data,
  inits,
  sim_metadata = NULL,
  model_code,
  niter = 50000,
  nburnin = 30000,
  nchains = 2,
  thin = 10,
  seed = NULL,
  save_plots = TRUE,
  output_dir = NULL
)
}
\arguments{
\item{constants}{List of model constants}

\item{data}{List of data}

\item{inits}{List of initial values}

\item{sim_metadata}{List with simulation metadata (optional)}

\item{model_code}{NIMBLE code object}

\item{niter}{Number of MCMC iterations (default: 50000)}

\item{nburnin}{Number of burn-in iterations (default: 30000)}

\item{nchains}{Number of MCMC chains (default: 2)}

\item{thin}{Thinning interval (default: 10)}

\item{seed}{Integer seed for reproducibility. Each chain uses seed+(chain_number-1) (default: NULL)}

\item{save_plots}{Logical, whether to save diagnostic plots (default: TRUE)}

\item{output_dir}{Directory for saving plots (default: NULL)}
}
\value{
List containing MCMC samples, summary, and convergence diagnostics
}
\description{
Run NIMBLE Model with Diagnostics
}
