% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intakes.R
\name{intake}
\alias{intake}
\title{Constructor for Intake Parameters}
\usage{
intake(x, ..., default = NULL, normalize = TRUE)
}
\arguments{
\item{x}{A `spacemodel` object or a `trophic_tbl`.}

\item{...}{Flux definitions.
- Key `"Target"` (e.g., `"Fox" = 0.5`): applies to all links pointing to Fox.
- Key `"Source -> Target"` (e.g., `"Soil -> Worm" = 0.8`): targets a specific link.
Values can be numeric (linear coefficient), formulas, or functions.}

\item{default}{The default function for unspecified links (default is identity).}

\item{normalize}{Logical. Whether to normalize diet weights (default TRUE).}
}
\value{
A `trophic_tbl` with a configured `flux` column.
}
\description{
Creates and configures the trophic flux table with a simplified syntax.
}
