% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey-country-population.R
\name{survey_country_population}
\alias{survey_country_population}
\title{Get survey country population data}
\usage{
survey_country_population(survey, countries = NULL)
}
\arguments{
\item{survey}{A \code{\link[=survey]{survey()}} object, with column "country" in "participants".}

\item{countries}{Optional. A character vector of country names. If specified,
this will be used instead of the potential "country" column in
"participants".}
}
\value{
A data table with population data by age group for the survey
countries, aggregated by lower age limit. The function will error if no
country information is available from either the survey or countries
argument.
}
\description{
Looks up the country and year inside a survey, or a provided
"countries" value, and determines the corresponding demographics in the world
population prospects data using \code{\link[=wpp_age]{wpp_age()}}.
}
\examples{
survey_country_population(polymod)
survey_country_population(polymod, countries = "Belgium")
survey_country_population(polymod, countries = c("Belgium", "Italy"))
}
