% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwm.r
\name{rgmwm}
\alias{rgmwm}
\title{GMWM for Robust/Classical Comparison}
\usage{
rgmwm(model, data, eff = c(0.9, 0.8, 0.6), ...)
}
\arguments{
\item{model}{A \code{ts.model} object containing one of the allowed models.}

\item{data}{A \code{matrix} or \code{data.frame} object with only one column (e.g. \eqn{N \times 1}{ N x 1 }), or a \code{lts} object, or a \code{gts} object.}

\item{eff}{A \code{double vector} between 0 and 1 that indicates the efficiency.}

\item{...}{Other arguments passed to the main \code{gmwm} function.}
}
\value{
A \code{rgmwm} object
}
\description{
Creates a \code{rgmwm} object to compare the results generated by robust/classical method.
}
\details{
By default, the \code{rgmwm} function will fit a classical \code{gmwm}
object. From there, the user has the ability to specify any \code{eff} that is
less than or equal to 0.99.
}
