% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{rJST}
\alias{rJST}
\alias{rJST.default}
\alias{rJST.LDA}
\title{Create a Reversed Joint Sentiment/Topic model}
\usage{
rJST(x, ...)

\method{rJST}{default}(
  x,
  lexicon = NULL,
  K = 5,
  S = 3,
  alpha = 1,
  gamma = 5,
  beta = 0.01,
  alphaCycle = 0,
  gammaCycle = 0,
  ...
)

\method{rJST}{LDA}(x, lexicon = NULL, S = 3, gamma = 5, ...)
}
\arguments{
\item{x}{tokens object containing the texts. A coercion will be attempted if \code{x} is not a tokens.}

\item{...}{not used}

\item{lexicon}{a \code{quanteda} dictionary with positive and negative categories}

\item{K}{the number of topics}

\item{S}{the number of sentiments}

\item{alpha}{the hyperparameter of topic-document distribution}

\item{gamma}{the hyperparameter of sentiment-document distribution}

\item{beta}{the hyperparameter of vocabulary distribution}

\item{alphaCycle}{integer specifying the cycle size between two updates of
the hyperparameter alpha}

\item{gammaCycle}{integer specifying the cycle size between two updates of
the hyperparameter alpha}
}
\value{
An S3 list containing the model parameter and the estimated mixture.
This object corresponds to a Gibbs sampler estimator with zero iterations.
The MCMC can be iterated using the \code{\link[=fit.sentopicmodel]{fit()}}
function.
\itemize{
\item \code{tokens} is the tokens object used to create the model
\item \code{vocabulary} contains the set of words of the corpus
\item \code{it} tracks the number of Gibbs sampling iterations
\item \code{za} is the list of topic assignment, aligned to the \code{tokens} object with
padding removed
\item \code{logLikelihood} returns the measured log-likelihood at each iteration,
with a breakdown of the likelihood into hierarchical components as
attribute
}

The \code{\link[=topWords]{topWords()}} function easily extract the most probables words of each
topic/sentiment.
}
\description{
This function initialize a Reversed Joint Sentiment/Topic model.
}
\details{
The \code{rJST.LDA} methods enable the transition from a previously
estimated \link{LDA} model to a sentiment-aware \code{rJST} model. The function
retains the previously estimated topics and randomly assigns sentiment to
every word of the corpus. The new model will retain the iteration count of
the initial \link{LDA} model.
}
\examples{
\donttest{# simple rJST model
rJST(ECB_press_conferences_tokens)

# estimating a rJST model including lexicon
rjst <- rJST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
rjst <- fit(rjst, 100)

# from an LDA model:
lda <- LDA(ECB_press_conferences_tokens)
lda <- fit(lda, 100)

# creating a rJST model out of it
rjst <- rJST(lda, lexicon = LoughranMcDonald)
# topic proportions remain identical
identical(lda$theta, rjst$theta)
# model should be iterated to estimate sentiment proportions
rjst <- fit(rjst, 100)}
}
\references{
Lin, C. and He, Y. (2009). \href{https://dl.acm.org/doi/10.1145/1645953.1646003}{Joint sentiment/topic model for sentiment analysis}. In \emph{Proceedings
of the 18th ACM conference on Information and knowledge management},
375--384.

Lin, C., He, Y., Everson, R. and Ruger, S. (2012). \href{https://ieeexplore.ieee.org/document/5710933}{Weakly Supervised Joint Sentiment-Topic Detection from Text}.
\emph{IEEE Transactions on Knowledge and Data Engineering}, 24(6), 1134–-1145.
}
\seealso{
Fitting a model: \code{\link[=fit.sentopicmodel]{fit()}}, extracting
top words: \code{\link[=topWords]{topWords()}}

Other topic models: 
\code{\link{JST}()},
\code{\link{LDA}()},
\code{\link{sentopicmodel}()}
}
\author{
Olivier Delmarcelle
}
\concept{topic models}
