################################################################################
# ----------------------------- logsdf_estimator ----------------------------- #
################################################################################

test_that("logsdf_estimator returns correct output type and length", {
  set.seed(1)
  n <- 128
  X <- rnorm(n)
  Te <- 8
  m <- floor(n / Te)
  shift <- (digamma(m / 2) - log(m / 2)) / sqrt(2)
  q <- 2
  D <- diag(n)
  evals <- rep(1, 2 * Te - 2)
  
  g <- logsdf_estimator(
    X = X,
    Te = Te,
    m = m,
    shift = shift,
    q = q,
    D = D,
    method = "GCV",
    f_true = NULL,
    evals = evals
  )
  
  expect_type(g, "double")
  expect_true(is.numeric(g))
  expect_length(g, length(evals))
  expect_false(any(is.na(g)))
})

test_that("logsdf_estimator uses smoothing parameter from smoothpar_selection", {
  n <- 64
  X <- rnorm(n)
  D <- diag(n)
  evals <- rep(1, 10)
  Te <- 4
  m <- 16
  q <- 3
  
  mock_smoothpar <- function(y, q, evals, method, f.true, sigma) {
    expect_equal(q, 3)
    expect_equal(method, "ML")
    expect_equal(sigma, 1 / m)
    return(0.123)
  }
  
  mock_SSper <- function(y, lambda, evals) {
    expect_equal(lambda, 0.123)
    return(rep(1, length(evals)))
  }
  
  local_mocked_bindings(
    smoothpar_selection = mock_smoothpar,
    SSper_estimator = mock_SSper
  )
  
  g <- logsdf_estimator(
    X = X,
    Te = Te,
    m = m,
    shift = 0,
    q = q,
    D = D,
    method = "ML",
    f_true = NULL,
    evals = evals
  )
  
  expect_equal(g, rep(1, length(evals)))
})

################################################################################
# ------------------------------ SSper_estimator ----------------------------- #
################################################################################

test_that("SSper_estimator rejects invalid lambda", {
  n <- 100
  y <- seq_len(n)
  evals <- rep(1, n)
  
  expect_error(
    SSper_estimator(y, lambda = -1, evals = evals),
    "lambda must be positive"
  )
  expect_error(
    SSper_estimator(y, lambda = 0, evals = evals),
    "lambda must be positive"
  )
})

test_that("SSper_estimator output type and length are correct", {
  n <- 100
  y <- seq_len(n)
  evals <- rep(1, n)
  lambda <- 1
  result <- SSper_estimator(y = y, lambda = lambda, evals = evals)
  
  expect_type(result, "double")
  expect_true(is.numeric(result))
  expect_length(result, n)
})