% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distribution.R
\name{visualize_selected_dist}
\alias{visualize_selected_dist}
\title{Visualize Selected vs. Target Fire Size Distribution}
\usage{
visualize_selected_dist(result, logaritmic = TRUE, target_hist, bins)
}
\arguments{
\item{result}{A list returned by a model or selection process.}

\item{logaritmic}{Logical. Defaults to \code{TRUE}.}

\item{target_hist}{A numeric vector containing the densities of the target distribution.}

\item{bins}{A numeric vector containing the bin limits (breaks) for the intervals.}
}
\value{
An object \code{ggplot}.
}
\description{
Visualize Selected vs. Target Fire Size Distribution
}
\examples{
\dontrun{
# Use example for select_events
visualize_selected_dist(result, logaritmic = TRUE,
                        target_hist = target_hist, bins = bins)
}

}
