% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fig_title_suffix_from_ggplot.R
\name{get_fig_title_suffix_from_ggplot}
\alias{get_fig_title_suffix_from_ggplot}
\title{Generate Figure Title Suffix with N Range and Optional Download Links}
\usage{
get_fig_title_suffix_from_ggplot(
  plot,
  save = FALSE,
  n_equals_string = "N = ",
  file_suffixes = c(".csv", ".png"),
  link_prefixes = c("[CSV](", "[PNG]("),
  save_fns = list(utils::write.csv, saros::ggsaver),
  sep = ", "
)
}
\arguments{
\item{plot}{A \code{ggplot2} object, typically created by \code{\link[=makeme]{makeme()}}.}

\item{save}{Logical flag. If \code{TRUE}, generates download links for the plot data (CSV)
and plot image (PNG). If \code{FALSE} (default), only returns the N range text.}

\item{n_equals_string}{String. Prefix text for the sample size display
(default: \code{"N = "}).}

\item{file_suffixes}{Character vector. File extensions for the saved plot images
(default: \code{".png"}). Should include the dot.}

\item{link_prefixes}{Character vector. Markdown link text prefixes for the plot download links
(default: \code{"[PNG]("}).}

\item{save_fns}{List of functions. Functions to save the plot data and images.}

\item{sep}{String. Separator between N range text and download links
(default: \code{", "}).}
}
\value{
An \code{AsIs} object (using \code{\link[=I]{I()}}) containing a character string with:
\itemize{
\item Sample size range formatted as "\{n_equals_string\}\{range\}"
\item If \code{save = TRUE}: additional download links for plot data and image, separated by \code{sep}
\item Empty string if \code{plot} is not a valid ggplot object or has no data
}
}
\description{
Creates a formatted suffix for figure titles that includes the sample size (N) range
from a ggplot object. Optionally generates markdown download links for both the
plot data and the plot image.
}
\details{
This function is particularly useful for adding informative captions to plots in
reports. The N range is calculated using \code{\link[=n_range2]{n_range2()}}, which extracts the sample
size from the plot data. When \code{save = TRUE}, the function creates downloadable
files using \code{\link[=make_link]{make_link()}}:
\itemize{
\item Plot data as CSV (via \code{utils::write.csv})
\item Plot image as PNG (via \code{\link[=ggsaver]{ggsaver()}})
}

The function returns an \code{AsIs} object to prevent automatic character escaping
in markdown/HTML contexts.
}
\examples{
# Create a sample plot
plot <- makeme(data = ex_survey, dep = b_1:b_3)

# Get just the N range text
get_fig_title_suffix_from_ggplot(plot)

# Custom N prefix
get_fig_title_suffix_from_ggplot(plot, n_equals_string = "Sample size: ")

\dontrun{
# Generate with download links (saves files to disk)
get_fig_title_suffix_from_ggplot(plot, save = TRUE)

# Custom separator and link prefix
get_fig_title_suffix_from_ggplot(
  plot,
  save = TRUE,
  sep = " | ",
  link_prefix = "[Download PNG]("
)
}
}
\seealso{
\itemize{
\item \code{\link[=n_range2]{n_range2()}} for extracting N range from ggplot objects
\item \code{\link[=make_link]{make_link()}} for creating download links
\item \code{\link[=ggsaver]{ggsaver()}} for saving ggplot objects
}
}
