% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffMRM.R
\name{processAllMRMAreas}
\alias{processAllMRMAreas}
\title{Process an MRM file in total}
\usage{
processAllMRMAreas(wiffFile, wiffScanFile, removeBaseline = TRUE, ...)
}
\arguments{
\item{wiffFile}{A valid file path to the Sciex data file (extension .wiff)
containing the metadata for one or more EchoMS runs}

\item{wiffScanFile}{An valid file path the the Sciex scan file (extension
.wiff.scan) containing the full raw EchoMS data}

\item{removeBaseline}{If TRUE, baseline intensity for each mass transition
will be subtracted from the intensities in each ejection, to account for
baseline intensities measured near the lower limit of quantitation}

\item{...}{Additional optional parameters to be passed to \code{\link[=measureEjections]{measureEjections()}}}
}
\value{
A list containing two data frames: \code{ejections}, with all extracted
TIC peaks for all runs, as output by \code{\link[=measureEjections]{measureEjections()}}, and \code{massAreas},
containing the measured areas for all mass transitoins and all peaks in all
runs, as output by \code{\link[=getMRMAreas]{getMRMAreas()}}.  Both data frames contain an addtional
\code{wiffSample} column indicating which run within the file the values were
extracted from.
}
\description{
This is a convenience function that performs an end to end analysis of an
Sciex MRM run; it can be used when the intermediate data structures (total
ion chromatograms, shot lists, .wiff file readers) are not required.
}
