% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiffFullScan.R
\name{getFullScanSpectrum}
\alias{getFullScanSpectrum}
\title{Extract a full mass spectrum for a given well}
\usage{
getFullScanSpectrum(scanfile, tic, sample, ejections, well)
}
\arguments{
\item{scanfile}{A file path to a Sciex raw scan file (extension .wiff.scan)
containing the raw data referenced by the .wiff file from which the other
parameters were extracted}

\item{tic}{A total ion chromatogram of the format outputby \code{\link[=getTIC]{getTIC()}} or
\code{\link[=getAllTIC]{getAllTIC()}}}

\item{sample}{The particular object from the \code{samples} field of the
\code{rtmsWiffReader} object, which in this case contains binary offsets into the
.wiff.scan file}

\item{ejections}{An ejection table listing the timing and boundaries of the
total ion chromatogram peaks for all shots in the run, as returned by
\code{\link[=measureEjections]{measureEjections()}}}

\item{well}{The well (a string) or well index (an integer) to be measured}
}
\value{
An object of class \code{rtmsSpectrum} representing the full mass
spectrum for the given well
}
\description{
Extract a full mass spectrum for a given well
}
