% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify_source.R
\name{prettify_source}
\alias{prettify_source}
\title{Prettify a source in HTML}
\usage{
prettify_source(
  x,
  heading = NULL,
  headingLevel = 2,
  add_html_tags = TRUE,
  output = NULL,
  outputViewer = "viewer",
  template = "default",
  includeCSS = TRUE,
  preserveSpaces = TRUE,
  includeBootstrap = rock::opts$get("includeBootstrap"),
  preventOverwriting = rock::opts$get(preventOverwriting),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{x}{The source, as imported with \code{\link[=load_source]{load_source()}} or as a path
to a file.}

\item{heading}{Optionally, a title to include in the output. The title
will be prefixed with \code{headingLevel} hashes (\verb{#}), and the codes with
\code{headingLevel+1} hashes. If \code{NULL} (the default), a heading will be
generated that includes the collected codes if those are five or less.
If a character value is specified, that will be used. To omit a heading,
set to anything that is not \code{NULL} or a character vector (e.g. \code{FALSE}).
If no heading is used, the code prefix will be \code{headingLevel} hashes,
instead of \code{headingLevel+1} hashes.}

\item{headingLevel}{The number of hashes to insert before the headings.}

\item{add_html_tags}{Whether to add HTML tags to the result.}

\item{output}{Here, a path and filename can be provided where the
result will be written. If provided, the result will be returned
invisibly.}

\item{outputViewer}{If showing output, where to show the output: in
the console (\code{outputViewer='console'}) or in the viewer
(\code{outputViewer='viewer'}), e.g. the RStudio viewer. You'll usually want
the latter when outputting HTML, and otherwise the former. Set to \code{FALSE}
to not output anything to the console or the viewer.}

\item{template}{The template to load; either the name of one
of the ROCK templates (currently, only 'default' is available), or
the path and filename of a CSS file.}

\item{includeCSS}{Whether to include the ROCK CSS in the returned HTML.}

\item{preserveSpaces}{Whether to preservce spaces (by replacing every second
space with \verb{&nbsp;}) or not.}

\item{includeBootstrap}{Whether to include the default bootstrap CSS.}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}
}
\value{
A character vector with the prettified source
}
\description{
This function adds HTML tags to a source to allow pretty printing/viewing.
For an example, visit \url{https://rock.opens.science/articles/rock.html}.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Prettify source; if using RStudio, by default the
### prettified source is shown in the viewer. You can
### view the output of this example in the "rock" vignette
### at https://rock.opens.science/articles/rock.html
rock::prettify_source(
  exampleFile
);
}
