% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess_source.R
\name{preprocess_source}
\alias{preprocess_source}
\title{Efficiently preprocess data}
\usage{
preprocess_source(
  input,
  output = NULL,
  clean = TRUE,
  cleaningArgs = NULL,
  wordwrap = TRUE,
  wrappingArgs = NULL,
  prependUIDs = TRUE,
  UIDArgs = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  rlWarn = rock::opts$get("rlWarn"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{The source}

\item{output}{For \code{clean_source} and \code{search_and_replace_in_source}, if not \code{NULL},
this is the name (and path) of the file in which to save the processed source (if it
\emph{is} \code{NULL}, the result will be returned visibly). For \code{clean_sources} and
\code{search_and_replace_in_sources}, \code{output} is mandatory and is the path to the
directory where to store the processed sources. This path will be created with a
warning if it does not exist. An exception is if "\code{same}" is specified - in that
case, every file will be written to the same directory it was read from.}

\item{clean}{Whether to clean}

\item{cleaningArgs}{Arguments to use for cleaning}

\item{wordwrap}{Whether to wordwrap}

\item{wrappingArgs}{Arguments to use for word wrapping}

\item{prependUIDs}{Whether to prepend UIDs}

\item{UIDArgs}{Arguments to use for prepending UIDs}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{encoding}{The encoding of the source(s).}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{silent}{Whether to suppress the warning about not editing the cleaned source.}
}
\value{
The preprocessed source as character vector.
}
\description{
Efficiently preprocess data
}
\examples{
exampleText <-
  paste0(
    "Lorem ipsum dolor sit amet, consectetur ",
    "adipiscing elit. Nunc non commodo ex, ac ",
    "varius mi. Praesent feugiat nunc eget urna ",
    "euismod lobortis. Sed hendrerit suscipit ",
    "nisl, ac tempus magna porta et. ",
    "Quisque libero massa, tempus vel tristique ",
    "lacinia, tristique in nulla. Nam cursus enim ",
    "dui, non ornare est tempor eu. Vivamus et massa ",
    "consectetur, tristique magna eget, viverra elit."
  );

### Show example text
cat(exampleText);

### Show preprocessed example text
rock::preprocess_source(
  exampleText
);
}
