% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepend_tssid_to_source.R
\name{prepend_tssid_to_source}
\alias{prepend_tssid_to_source}
\title{Prepend a line with a TSSID to a source}
\usage{
prepend_tssid_to_source(
  input,
  moment = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M"),
  output = NULL,
  designationSymbol = "=",
  preventOverwriting = rock::opts$get("preventOverwriting"),
  rlWarn = rock::opts$get(rlWarn),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{The source, as produced by one of the \code{loading_sources}
functions, or a path to an existing file that is then imported.}

\item{moment}{Optionally, the moment as a character value of the form
\verb{2025-05-28 11:30 CEST} (so, \verb{YYYY-MM-DD HH-MM}).}

\item{output}{If specified, the coded source will be written here.}

\item{designationSymbol}{The symbol to use to designate an instance
identifier for a class (can be "\code{=}" or "\code{:}" as per the ROCK standard).}

\item{preventOverwriting}{Whether to prevent overwriting existing files.}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}
}
\value{
Invisibly, the coded source object.
}
\description{
This function adds a line with a TSSID (a time-stamped source identifier)
to the beginning of a source that was read with one of
the \code{loading_sources} functions. When combined with UIDs, TSSIDs are
virtually unique references to a specific data fragment.
}
\details{
TSSIDs are a date and time in the UTC timezone, consisting of eight digits
(four for the year, two for the month, and two for the day), a \code{T}, four
digits (two for the hour and two for the minute), and a \code{Z} (to designate
that the time is specified in the UTC timezone). TSSIDs are valid ISO8601
standard date/times.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
loadedExample <-
  rock::load_source(exampleFile);

### Add a coder identifier
loadedExample <-
  rock::prepend_tssid_to_source(
    loadedExample,
    moment = "2025-05-28 11:30 CEST"
  );

### Show the first line
cat(loadedExample[1]);

}
