% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_coded_fragments.R
\name{collect_coded_fragments}
\alias{collect_coded_fragments}
\title{Create an overview of coded fragments}
\usage{
collect_coded_fragments(
  x,
  codes = ".*",
  context = 0,
  includeDescendents = FALSE,
  attributes = NULL,
  heading = NULL,
  headingLevel = 3,
  add_html_tags = TRUE,
  cleanUtterances = FALSE,
  omitEmptyCodes = TRUE,
  output = NULL,
  outputViewer = "viewer",
  template = "default",
  rawResult = FALSE,
  includeCSS = TRUE,
  preserveSpaces = TRUE,
  codeHeadingFormatting = rock::opts$get("codeHeadingFormatting"),
  codeHeadingFormatting_html = rock::opts$get("codeHeadingFormatting_html"),
  includeBootstrap = rock::opts$get("includeBootstrap"),
  preventOverwriting = rock::opts$get("preventOverwriting"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The parsed source(s) as provided by \code{rock::parse_source}
or \code{rock::parse_sources}.}

\item{codes}{The regular expression that matches the codes to include,
or a character vector with codes or regular expressions for codes (which
will be prepended with "\code{^}" and appended with "\code{$}", and then
concatenated using "\code{|}" as a separator, to create a regular expression
matching all codes).}

\item{context}{How many utterances before and after the target
utterances to include in the fragments. If two values, the first is the
number of utterances before, and the second, the number of utterances
after the target utterances.}

\item{includeDescendents}{Whether to also collect the fragments coded with
descendent codes (i.e. child codes, 'grand child codes', etc; in other
words, whether to collect the fragments recursively).}

\item{attributes}{To only select coded utterances matching one or more
values for one or more attributes, pass a list where every element's
name is a valid (i.e. occurring) attribute name, and every element is a
character value with a regular expression specifying all values for that
attribute to select.}

\item{heading}{Optionally, a title to include in the output. The title
will be prefixed with \code{headingLevel} hashes (\verb{#}), and the codes with
\code{headingLevel+1} hashes. If \code{NULL} (the default), a heading will be
generated that includes the collected codes if those are five or less.
If a character value is specified, that will be used. To omit a heading,
set to anything that is not \code{NULL} or a character vector (e.g. \code{FALSE}).
If no heading is used, the code prefix will be \code{headingLevel} hashes,
instead of \code{headingLevel+1} hashes.}

\item{headingLevel}{The number of hashes to insert before the headings.}

\item{add_html_tags}{Whether to add HTML tags to the result.}

\item{cleanUtterances}{Whether to use the clean or the raw utterances
when constructing the fragments (the raw versions contain all codes). Note that
this should be set to \code{FALSE} to have \code{add_html_tags} be of the most use.}

\item{omitEmptyCodes}{Whether to still show the title for codes that do not
occur or not.}

\item{output}{Here, a path and filename can be provided where the
result will be written. If provided, the result will be returned
invisibly.}

\item{outputViewer}{If showing output, where to show the output: in
the console (\code{outputViewer='console'}) or in the viewer
(\code{outputViewer='viewer'}), e.g. the RStudio viewer. You'll usually want
the latter when outputting HTML, and otherwise the former. Set to \code{FALSE}
to not output anything to the console or the viewer.}

\item{template}{The template to load; either the name of one
of the ROCK templates (currently, only 'default' is available), or
the path and filename of a CSS file.}

\item{rawResult}{Whether to return the raw result, a list of the
fragments, or one character value in markdown format.}

\item{includeCSS}{Whether to include the ROCK CSS in the returned HTML.}

\item{preserveSpaces}{Whether to preserve spaces in the output (replacing
double spaces with "\verb{&nbsp;&nbsp;}").}

\item{codeHeadingFormatting, codeHeadingFormatting_html}{A character value of the
form \verb{\%s *(path: \%s)*} (the default) or \verb{\\n\\n### \%s\\n\\n*path:* ``\%s``\\n\\n}.
The first \verb{\%s} is replaced by the code identifier; the second \verb{\%s} by the
corresponding path in the code tree; for markdown/console and html output,
respectively.}

\item{includeBootstrap}{Whether to include the default bootstrap CSS.}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}
}
\value{
Either a list of character vectors, or a single character value.
}
\description{
Collect all coded utterances and optionally add some context
(utterances before and utterances after) to create an overview
of all coded fragments per code.
}
\details{
By default, the output is optimized for inclusion in an R Markdown
document. To optimize output for the R console or a plain text
file, without any HTML codes, set \code{add_html_tags} to FALSE, and
potentially set \code{cleanUtterances} to only return the utterances,
without the codes.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(
    examplePath, "example-.rock"
  );

### Parse single example source
parsedExample <-
  rock::parse_source(
    exampleFile
  );

### Show organised coded fragments in Markdown
cat(
  rock::collect_coded_fragments(
    parsedExample
  )
);

### Only for the codes containing 'Code2', with
### 2 lines of context (both ways)
cat(
  rock::collect_coded_fragments(
    parsedExample,
    'Code2',
    context = 2
  )
);

### Parse multiple example sources
### Load two example sources
parsedExamples <- rock::parse_sources(
  examplePath,
  regex = "example-[1234].rock"
);

cat(
  rock::collect_coded_fragments(
    parsedExamples,
    '[cC]ode2',
    context = 2
  )
);


}
