% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebook_to_pdf.R
\name{codebook_to_pdf}
\alias{codebook_to_pdf}
\title{Convert a codebook specification to PDF}
\usage{
codebook_to_pdf(
  x,
  file,
  author = NULL,
  headingLevel = 1,
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The codebook object (as produced by a call to
\code{\link[=codebook_fromSpreadsheet]{codebook_fromSpreadsheet()}}).}

\item{file}{The filename to save the codebook to.}

\item{author}{The author to specify in the PDF.}

\item{headingLevel}{The level of the top-most headings.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Use this function to export your codebook specification to a PDF
file. To embed it in an R Markdown file, use
!!! CREATE rock::knit_codebook() !!!
}
\examples{
\donttest{
### Use a temporary file to write to
tmpFile <- tempfile(fileext = ".pdf");

### Load an example (pre)registration specification
data("exampleCodebook_1", package = "rock");

rock::codebook_to_pdf(
  exampleCodebook_1,
  file = tmpFile
);
}
}
