% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepend_ciids_to_source.R,
%   R/prepend_ciids_to_sources.R
\name{prepend_ciids_to_source}
\alias{prepend_ciids_to_source}
\alias{prepend_ciids_to_sources}
\title{Prepend lines with one or more class instance identifiers to one or more sources}
\usage{
prepend_ciids_to_source(
  input,
  ciids,
  output = NULL,
  allOnOneLine = FALSE,
  designationSymbol = "=",
  preventOverwriting = rock::opts$get("preventOverwriting"),
  rlWarn = rock::opts$get(rlWarn),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)

prepend_ciids_to_sources(
  input,
  ciids,
  output = NULL,
  outputPrefix = "",
  outputSuffix = "_coded",
  recursive = TRUE,
  filenameRegex = ".*",
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{The source, or list of sources, as
produced by one of the \code{loading_sources} functions.}

\item{ciids}{A named character vector, where each element's name
is the class identifier (e.g. "codeId" or "participantId") and each
element is the class instance identifier.}

\item{output}{If specified, the coded source will be written here.}

\item{allOnOneLine}{Whether to add all class instance identifiers to one
line (\code{TRUE}) or add then on successive lines (\code{FALSE}).}

\item{designationSymbol}{The symbol to use to designate an instance
identifier for a class (can be "\code{=}" or "\code{:}" as per the ROCK standard).}

\item{preventOverwriting}{Whether to prevent overwriting existing files.}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}

\item{outputPrefix, outputSuffix}{A prefix and/or suffix to prepend and/or
append to the filenames to distinguish them from the input filenames.}

\item{recursive}{Whether to also read files from all subdirectories
of the \code{input} directory}

\item{filenameRegex}{Only input files matching this patterns will be read.}
}
\value{
Invisibly, the coded source object.
}
\description{
These functions add lines with class instance identifiers to the beginning
of one or more sources that were read with one of the
\code{loading_sources} functions.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
loadedExample <-
  rock::load_source(exampleFile);

### Add a coder identifier
loadedExample <-
  rock::prepend_ciids_to_source(
    loadedExample,
    c("codeId" = "iz0dn96")
  );

### Show lines 1-5
cat(loadedExample[1:5]);

}
