% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_assemblages.R
\name{road_get_assemblages}
\alias{road_get_assemblages}
\title{Get assemblages from the ROAD database}
\usage{
road_get_assemblages(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe).
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")}
to display possible values.
The argument \code{country} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")}
to display possible values. The argument \code{cultural_period} is a string
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes
human remains, raw material, typology, technology, function, organic tools,
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains,
plant remains. The argument \code{category} is a string (one item) or
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}
}
\value{
A data frame with assemblage information. Rows represent individual assemblages, columns contain:

\code{locality_id}: The unique identifier for the locality where the assemblage was found.

\code{continent}, \code{subcontinent}, \code{country}: The attributes specify the geopolitical information of the locality.

\code{locality_type}: The attribute specifies the type of locality (e.g. cave, rockshelter, open air).

\code{coord_x}, \code{coord_y}: The attributes specify the geographic coordinates (longitude and latitude) of the locality.

\code{coordinate_source}: The source of the geographic coordinates.

\code{assemblage_id}: The unique identifier for the assemblage.

\code{assemblage_name}: The name or designation of the assemblage.

\code{category}: The assemblage category (e.g., human remains, raw material, typology, paleofauna, plant remains).

\code{age_min}: The minimum age of the assemblage in years before present (BP), based on associated geological stratigraphy.

\code{age_max}: The maximum age of the assemblage in years before present (BP), based on associated geological stratigraphy.

\code{geolayers}: The name(s) of the geological layer(s) associated with the assemblage.

\code{archlayers}: The name(s) of the archaeological layer(s) associated with the assemblage.

\code{cultural_period}: The cultural period(s) associated with the assemblage (e.g., Lower Paleolithic, Middle Stone Age).

\code{technocomplex}: The archaeological culture(s) or stone tool industry/industries associated with the assemblage (e.g., Acheulean, Mousterian).

\code{is_systematic}: Description of the collection method quality (excavation, survey, or opportunistic collection).

\code{human_remains}: Logical value indicating whether the assemblage contains human remains.

\code{paleofauna}: Logical value indicating whether the assemblage contains paleofauna.

\code{archaeology}: Logical value indicating whether the assemblage contains archaeological finds.

\code{plant_remains}: Logical value indicating whether the assemblage contains plant remains.
}
\description{
The \strong{\code{road_get_assemblages}} function retrieves data on assemblages from the ROAD database.
The ROAD table assemblage contains information about classes of finds. An assemblage is
defined as a collected find consisting of grouped classes of materials, for example:
archaeological finds (including raw material, typology, technology, function, organic tools,
symbolic artifacts, feature and miscellaneous finds), human remains, faunal remains or
botanical remains. An assemblage comes from a single geological layer or several
geological layers of a locality, whether the nature of the locality is geological,
archaeological or paleontological. Each physical object contained in any assemblage
can appear only once in this table.
}
\details{
Use parameters to filter search results by location, type, culture, assemblage
category, age or omit them to have a broader result set.
All parameters are optional and should be omitted or set to NULL when not used.
}
\examples{
\donttest{road_get_assemblages(country = c("Germany", "France"), age_min = 300000,
                     category = c("miscellaneous finds"))}
\donttest{road_get_assemblages(subcontinent = c("Caucasus"), category = "human remains",
                     age_max = 100000)}
}
