% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptation.R
\name{robust_shape_adapter}
\alias{robust_shape_adapter}
\title{Create object to adapt proposal shape (and scale) using robust adaptive
Metropolis algorithm of Vihola (2012).}
\usage{
robust_shape_adapter(
  initial_scale = NULL,
  target_accept_prob = NULL,
  kappa = 0.6
)
}
\arguments{
\item{initial_scale}{Initial value to use for scale parameter. If not set
explicitly a proposal and dimension dependent default will be used.}

\item{target_accept_prob}{Target value for average accept probability for
chain. If not set a proposal dependent default will be used.}

\item{kappa}{Decay rate exponent in \verb{[0.5, 1]} for adaptation learning rate.}
}
\value{
List of functions with entries
\itemize{
\item \code{initialize}, a function for initializing adapter state and proposal
parameters at beginning of chain,
\item \code{update} a function for updating adapter state and proposal parameters on
each chain iteration,
\item \code{finalize} a function for performing any final updates to adapter state and
proposal parameters on completion of chain sampling (may be \code{NULL} if
unused).
\item \code{state} a zero-argument function for accessing current values of adapter
state variables.
}
}
\description{
Requires \code{ramcmc} package to be installed.
}
\examples{
proposal <- barker_proposal()
adapter <- robust_shape_adapter(initial_scale = 1., target_accept_prob = 0.4)
adapter$initialize(proposal, chain_state(c(0, 0)))
}
\references{
Vihola, M. (2012). Robust adaptive Metropolis algorithm with
coerced acceptance rate. \emph{Statistics and Computing}, 22, 997-1008.
\doi{10.1007/s11222-011-9269-5}
}
