/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.sarima;

import java.util.Arrays;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.arima.SarmaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.core.arima.AbstractArimaModel;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.sarima.SarimaUtility;

public final class SarimaModel
extends AbstractArimaModel {
    public static final double SMALL = 1.0E-6;
    private final int s;
    private final int d;
    private final int bd;
    private final double[] phi;
    private final double[] bphi;
    private final double[] th;
    private final double[] bth;

    public static Builder builder(SarimaOrders spec) {
        return new Builder(spec);
    }

    public static Builder builder(SarmaOrders spec) {
        return new Builder(spec);
    }

    public static Builder builder(SarimaSpec spec) {
        return new Builder(spec);
    }

    public static Builder builder(int period) {
        return new Builder(period);
    }

    private SarimaModel(Builder builder) {
        this.s = builder.s;
        this.d = builder.d;
        this.bd = builder.bd;
        this.phi = builder.phi;
        this.bphi = builder.bphi;
        this.th = builder.th;
        this.bth = builder.bth;
    }

    public DoubleSeq parameters() {
        double[] p = new double[this.phi.length + this.bphi.length + this.th.length + this.bth.length];
        int pos = 0;
        if (this.phi.length > 0) {
            System.arraycopy(this.phi, 0, p, pos, this.phi.length);
            pos += this.phi.length;
        }
        if (this.bphi.length > 0) {
            System.arraycopy(this.bphi, 0, p, pos, this.bphi.length);
            pos += this.bphi.length;
        }
        if (this.th.length > 0) {
            System.arraycopy(this.th, 0, p, pos, this.th.length);
            pos += this.th.length;
        }
        if (this.bth.length > 0) {
            System.arraycopy(this.bth, 0, p, pos, this.bth.length);
        }
        return DoubleSeq.of((double[])p);
    }

    public double phi(int lag) {
        return this.phi[lag - 1];
    }

    private DoubleSeq clone(double[] x) {
        return x.length == 0 ? DoubleSeq.empty() : DoubleSeq.of((double[])((double[])x.clone()));
    }

    public DoubleSeq getPhi() {
        return this.clone(this.phi);
    }

    public double bphi(int lag) {
        return this.bphi[lag - 1];
    }

    public DoubleSeq getBphi() {
        return this.clone(this.bphi);
    }

    public double theta(int lag) {
        return this.th[lag - 1];
    }

    public DoubleSeq getTheta() {
        return this.clone(this.th);
    }

    public double btheta(int lag) {
        return this.bth[lag - 1];
    }

    public DoubleSeq getBtheta() {
        return this.clone(this.bth);
    }

    @Override
    public BackFilter getAr() {
        BackFilter df = SarimaUtility.differencingFilter(this.s, this.d, this.bd);
        BackFilter st = this.getStationaryAr();
        return df.times(st);
    }

    @Override
    public int getArOrder() {
        int n = this.d + this.phi.length;
        if (this.s != 1) {
            n += this.s * (this.bd + this.bphi.length);
        }
        return n;
    }

    public int getDifferencingOrder() {
        int n = this.d;
        if (this.s > 1) {
            n += this.s * this.bd;
        }
        return n;
    }

    public int getPeriod() {
        return this.s;
    }

    @Override
    public double getInnovationVariance() {
        return 1.0;
    }

    @Override
    public BackFilter getMa() {
        Polynomial pr = this.getRegularMA();
        Polynomial ps = this.seasonalMA();
        return new BackFilter(pr.times(ps, false));
    }

    @Override
    public int getMaOrder() {
        int n = this.th.length;
        if (this.s != 1) {
            n += this.s * this.bth.length;
        }
        return n;
    }

    @Override
    public BackFilter getNonStationaryAr() {
        return SarimaUtility.differencingFilter(this.s, this.d, this.bd);
    }

    @Override
    public int getNonStationaryArOrder() {
        return this.getDifferencingOrder();
    }

    public int getParametersCount() {
        return this.phi.length + this.bphi.length + this.th.length + this.bth.length;
    }

    public Polynomial getRegularAR() {
        int n = this.phi.length;
        double[] p = new double[1 + n];
        p[0] = 1.0;
        if (n > 0) {
            System.arraycopy(this.phi, 0, p, 1, n);
        }
        return Polynomial.ofInternal(p);
    }

    public int getD() {
        return this.d;
    }

    public int getP() {
        return this.phi.length;
    }

    public int getQ() {
        return this.th.length;
    }

    public Polynomial getRegularMA() {
        int n = this.th.length;
        double[] p = new double[1 + n];
        p[0] = 1.0;
        if (n > 0) {
            System.arraycopy(this.th, 0, p, 1, n);
        }
        return Polynomial.ofInternal(p);
    }

    public Polynomial getSeasonalAR() {
        int n = this.bphi.length;
        double[] p = new double[1 + n];
        p[0] = 1.0;
        if (n > 0) {
            System.arraycopy(this.bphi, 0, p, 1, n);
        }
        return Polynomial.ofInternal(p);
    }

    private Polynomial seasonalAR() {
        if (this.bphi.length == 0) {
            return Polynomial.ONE;
        }
        if (this.bphi.length == 1) {
            return Polynomial.factor(-this.bphi[0], this.s);
        }
        double[] p = new double[this.bphi.length * this.s + 1];
        p[0] = 1.0;
        int i = this.s;
        int j = 0;
        while (i < this.bphi.length) {
            p[i] = this.bphi[j];
            i += this.s;
            ++j;
        }
        return Polynomial.ofInternal(p);
    }

    private Polynomial seasonalMA() {
        if (this.bth.length == 0) {
            return Polynomial.ONE;
        }
        if (this.bth.length == 1) {
            return Polynomial.factor(-this.bth[0], this.s);
        }
        double[] p = new double[this.bth.length * this.s + 1];
        p[0] = 1.0;
        int i = this.s;
        int j = 0;
        while (i < this.bth.length) {
            p[i] = this.bth[j];
            i += this.s;
            ++j;
        }
        return Polynomial.ofInternal(p);
    }

    public int getBd() {
        return this.bd;
    }

    public int getBp() {
        return this.bphi.length;
    }

    public int getBq() {
        return this.bth.length;
    }

    public Polynomial getSeasonalMA() {
        int n = this.bth.length;
        double[] p = new double[1 + n];
        p[0] = 1.0;
        if (n > 0) {
            System.arraycopy(this.bth, 0, p, 1, n);
        }
        return Polynomial.ofInternal(p);
    }

    public SarimaOrders orders() {
        SarimaOrders spec = new SarimaOrders(this.s);
        spec.setD(this.d);
        spec.setBd(this.bd);
        spec.setP(this.phi.length);
        spec.setBp(this.bphi.length);
        spec.setQ(this.th.length);
        spec.setBq(this.bth.length);
        return spec;
    }

    @Override
    public BackFilter getStationaryAr() {
        Polynomial pr = this.getRegularAR();
        Polynomial ps = this.seasonalAR();
        return new BackFilter(pr.times(ps, true));
    }

    @Override
    public int getStationaryArOrder() {
        int n = this.phi.length;
        if (this.s != 1) {
            n += this.s * this.bphi.length;
        }
        return n;
    }

    @Override
    public boolean isInvertible() {
        return FilterUtility.checkStability(DoubleSeq.of((double[])this.th)) && FilterUtility.checkStability(DoubleSeq.of((double[])this.bth));
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean isStable(boolean checkMA) {
        boolean pos = false;
        if (!FilterUtility.checkStability((DoubleSeq)DataBlock.of(this.phi))) {
            return false;
        }
        if (!FilterUtility.checkStability((DoubleSeq)DataBlock.of(this.bphi))) {
            return false;
        }
        if (checkMA) {
            if (!FilterUtility.checkStability((DoubleSeq)DataBlock.of(this.th))) {
                return false;
            }
            if (!FilterUtility.checkStability((DoubleSeq)DataBlock.of(this.bth))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isStationary() {
        return this.d == 0 && this.bd == 0;
    }

    public boolean isWhiteNoise() {
        return this.getParametersCount() == 0 && this.d == 0 && this.bd == 0;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public StationaryTransformation<SarimaModel> stationaryTransformation() {
        if (this.isStationary()) {
            return new StationaryTransformation<SarimaModel>(this, BackFilter.ONE);
        }
        BackFilter ur = this.getNonStationaryAr();
        Builder builder = this.toBuilder();
        builder.differencing(0, 0);
        return new StationaryTransformation<SarimaModel>(builder.build(), ur);
    }

    public boolean isAirline(boolean seas) {
        if (seas) {
            return this.phi.length == 0 && this.bphi.length == 0 && this.d == 1 && this.bd == 1 && this.th.length == 1 && this.bth.length == 1;
        }
        return this.phi.length == 0 && this.bphi.length == 0 && this.bd == 0 && this.bth.length == 0 && this.d == 1 && this.th.length == 1;
    }

    public boolean equals(Object other) {
        if (other instanceof SarimaModel) {
            SarimaModel m = (SarimaModel)other;
            return this.s == m.s && this.d == m.d && this.bd == m.bd && Arrays.equals(this.phi, m.phi) && Arrays.equals(this.bphi, m.bphi) && Arrays.equals(this.th, m.th) && Arrays.equals(this.bth, m.bth);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + this.s;
        hash = 43 * hash + this.d;
        hash = 43 * hash + this.bd;
        hash = 43 * hash + Arrays.hashCode(this.phi);
        hash = 43 * hash + Arrays.hashCode(this.bphi);
        hash = 43 * hash + Arrays.hashCode(this.th);
        hash = 43 * hash + Arrays.hashCode(this.bth);
        return hash;
    }

    public static class Builder {
        private final int s;
        private int d;
        private int bd;
        private double[] phi;
        private double[] bphi;
        private double[] th;
        private double[] bth;
        private boolean adjust = false;
        public static final double AR = -0.1;
        public static final double MA = -0.2;

        private Builder(int period) {
            this.s = period;
            this.phi = Doubles.EMPTYARRAY;
            this.bphi = Doubles.EMPTYARRAY;
            this.th = Doubles.EMPTYARRAY;
            this.bth = Doubles.EMPTYARRAY;
        }

        private Builder(SarimaOrders spec) {
            this.s = spec.getPeriod();
            this.d = spec.getD();
            this.bd = spec.getBd();
            this.phi = spec.getP() > 0 ? new double[spec.getP()] : Doubles.EMPTYARRAY;
            this.bphi = spec.getBp() > 0 ? new double[spec.getBp()] : Doubles.EMPTYARRAY;
            this.th = spec.getQ() > 0 ? new double[spec.getQ()] : Doubles.EMPTYARRAY;
            this.bth = spec.getBq() > 0 ? new double[spec.getBq()] : Doubles.EMPTYARRAY;
        }

        private Builder(SarimaSpec spec) {
            this.s = spec.getPeriod();
            this.d = spec.getD();
            this.bd = spec.getBd();
            this.phi = Parameter.values((Parameter[])spec.getPhi(), (double)-0.1);
            this.bphi = Parameter.values((Parameter[])spec.getBphi(), (double)-0.1);
            this.th = Parameter.values((Parameter[])spec.getTheta(), (double)-0.2);
            this.bth = Parameter.values((Parameter[])spec.getBtheta(), (double)-0.2);
        }

        private Builder(SarmaOrders spec) {
            this.s = spec.getPeriod();
            this.d = 0;
            this.bd = 0;
            this.phi = spec.getP() > 0 ? new double[spec.getP()] : Doubles.EMPTYARRAY;
            this.bphi = spec.getBp() > 0 ? new double[spec.getBp()] : Doubles.EMPTYARRAY;
            this.th = spec.getQ() > 0 ? new double[spec.getQ()] : Doubles.EMPTYARRAY;
            this.bth = spec.getBq() > 0 ? new double[spec.getBq()] : Doubles.EMPTYARRAY;
        }

        private double[] clone(double[] c) {
            if (c.length == 0) {
                return Doubles.EMPTYARRAY;
            }
            return (double[])c.clone();
        }

        private Builder(SarimaModel model) {
            this.s = model.s;
            this.d = model.d;
            this.bd = model.bd;
            this.phi = this.clone(model.phi);
            this.bphi = this.clone(model.bphi);
            this.th = this.clone(model.th);
            this.bth = this.clone(model.bth);
        }

        public Builder adjustOrders(boolean adjust) {
            this.adjust = adjust;
            return this;
        }

        public Builder setDefault() {
            return this.setDefault(-0.1, -0.2);
        }

        public Builder setDefault(double ar, double ma) {
            int i;
            for (i = 0; i < this.phi.length; ++i) {
                this.phi[i] = ar;
            }
            for (i = 0; i < this.bphi.length; ++i) {
                this.bphi[i] = ar;
            }
            for (i = 0; i < this.th.length; ++i) {
                this.th[i] = ma;
            }
            for (i = 0; i < this.bth.length; ++i) {
                this.bth[i] = ma;
            }
            return this;
        }

        public Builder parameters(DoubleSeq p) {
            int i;
            DoubleSeqCursor reader = p.cursor();
            for (i = 0; i < this.phi.length; ++i) {
                this.phi[i] = reader.getAndNext();
            }
            for (i = 0; i < this.bphi.length; ++i) {
                this.bphi[i] = reader.getAndNext();
            }
            for (i = 0; i < this.th.length; ++i) {
                this.th[i] = reader.getAndNext();
            }
            for (i = 0; i < this.bth.length; ++i) {
                this.bth[i] = reader.getAndNext();
            }
            return this;
        }

        public Builder phi(int lag, double val) {
            this.phi[lag - 1] = val;
            return this;
        }

        public Builder bphi(int lag, double val) {
            this.bphi[lag - 1] = val;
            return this;
        }

        public Builder theta(int lag, double val) {
            this.th[lag - 1] = val;
            return this;
        }

        public Builder btheta(int lag, double val) {
            this.bth[lag - 1] = val;
            return this;
        }

        public Builder phi(double ... val) {
            if (val == null) {
                this.phi = Doubles.EMPTYARRAY;
            } else if (val.length == this.phi.length) {
                System.arraycopy(val, 0, this.phi, 0, this.phi.length);
            } else {
                this.phi = (double[])val.clone();
            }
            return this;
        }

        public Builder bphi(double ... val) {
            if (val == null) {
                this.bphi = Doubles.EMPTYARRAY;
            } else if (val.length == this.bphi.length) {
                System.arraycopy(val, 0, this.bphi, 0, this.bphi.length);
            } else {
                this.bphi = (double[])val.clone();
            }
            return this;
        }

        public Builder theta(double ... val) {
            if (val == null) {
                this.th = Doubles.EMPTYARRAY;
            } else if (val.length == this.th.length) {
                System.arraycopy(val, 0, this.th, 0, this.th.length);
            } else {
                this.th = (double[])val.clone();
            }
            return this;
        }

        public Builder btheta(double ... val) {
            if (val == null) {
                this.bth = Doubles.EMPTYARRAY;
            } else if (val.length == this.bth.length) {
                System.arraycopy(val, 0, this.bth, 0, this.bth.length);
            } else {
                this.bth = (double[])val.clone();
            }
            return this;
        }

        public Builder differencing(int d, int bd) {
            this.d = d;
            this.bd = bd;
            return this;
        }

        private void adjust() {
            double[] nbth;
            double[] nth;
            double[] nbphi;
            double[] nphi = this.adjust(this.phi);
            if (nphi != null) {
                this.phi = nphi;
            }
            if ((nbphi = this.adjust(this.bphi)) != null) {
                this.bphi = nbphi;
            }
            if ((nth = this.adjust(this.th)) != null) {
                this.th = nth;
            }
            if ((nbth = this.adjust(this.bth)) != null) {
                this.bth = nbth;
            }
        }

        private double[] adjust(double[] p) {
            int l = p.length;
            for (int i = l - 1; i >= 0 && Math.abs(p[i]) < 1.0E-6; --i) {
                --l;
            }
            if (l != p.length) {
                double[] np = new double[l];
                if (l > 0) {
                    System.arraycopy(p, 0, np, 0, l);
                }
                return np;
            }
            return null;
        }

        public SarimaModel build() {
            if (this.adjust) {
                this.adjust();
            }
            return new SarimaModel(this);
        }
    }
}

