/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.xml.information;

import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.xml.information.XmlMetaData;
import jdplus.toolkit.base.xml.information.XmlTs;
import jdplus.toolkit.base.xml.legacy.IXmlConverter;

@XmlRootElement(name="tsCollection")
@XmlType(name="tsCollectionType")
public class XmlTsCollection
implements IXmlConverter<TsCollection> {
    static final String NAME = "tsCollectionType";
    static final String RNAME = "tsCollection";
    @XmlElement
    public XmlMetaData metadata;
    @XmlAttribute
    public String name;
    @XmlAttribute
    public String source;
    @XmlAttribute
    public String identifier;
    @XmlElement(name="ts")
    @XmlElementWrapper(name="data")
    public XmlTs[] tslist;

    @Override
    public void copy(TsCollection t) {
        this.source = t.getMoniker().getSource();
        this.identifier = t.getMoniker().getId();
        this.name = t.getName();
        Map meta = t.getMeta();
        if (meta == null || meta.isEmpty()) {
            this.metadata = null;
        } else {
            this.metadata = new XmlMetaData();
            this.metadata.copy(meta);
        }
        List items = t.getItems();
        int n = items.size();
        if (n > 0) {
            this.tslist = new XmlTs[n];
            for (int i = 0; i < n; ++i) {
                XmlTs s = new XmlTs();
                s.copy((Ts)items.get(i));
                this.tslist[i] = s;
            }
        } else {
            this.tslist = null;
        }
    }

    @Override
    public TsCollection create() {
        TsMoniker moniker = this.source == null && this.identifier == null ? TsMoniker.of() : TsMoniker.of((String)this.source, (String)this.identifier);
        TsCollection.Builder cinfo = TsCollection.builder().moniker(moniker).type(TsInformationType.UserDefined).name(this.name);
        if (this.metadata != null) {
            cinfo.meta((Map)this.metadata.create());
        }
        if (this.tslist != null) {
            for (int i = 0; i < this.tslist.length; ++i) {
                cinfo.item(this.tslist[i].create());
            }
        }
        return cinfo.build();
    }
}

